/*
 * Decompiled with CFR 0.152.
 */
package com.power4j.fist.boot.autoconfigure.data;

import com.power4j.fist.data.crud.validate.DefaultObjectValidator;
import com.power4j.fist.data.crud.validate.ObjectValidator;
import com.power4j.fist.data.crud.validate.ValidateUtil;
import com.power4j.fist.data.tenant.InTenantAspect;
import com.power4j.fist.data.tenant.TenantContextFilter;
import com.power4j.fist.data.tenant.TenantInvokeAspect;
import jakarta.servlet.DispatcherType;
import jakarta.servlet.Filter;
import jakarta.servlet.Servlet;
import jakarta.validation.ValidatorFactory;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.springframework.boot.web.servlet.FilterRegistrationBean;
import org.springframework.boot.web.servlet.ServletRegistrationBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.EnableAspectJAutoProxy;

@AutoConfiguration
@EnableAspectJAutoProxy
public class DataAutoConfiguration {
    @Bean
    public InTenantAspect inTenantAspect() {
        return new InTenantAspect();
    }

    @Bean
    public TenantInvokeAspect tenantInvokeAspect() {
        return new TenantInvokeAspect();
    }

    @Configuration
    static class ValidationConfiguration {
        ValidationConfiguration() {
        }

        @Bean
        @ConditionalOnMissingBean
        public ValidatorFactory validatorFactory() {
            return ValidateUtil.createValidatorFactory();
        }

        @Bean
        @ConditionalOnMissingBean
        public ObjectValidator objectValidator(ValidatorFactory validatorFactory) {
            return new DefaultObjectValidator(validatorFactory.getValidator());
        }
    }

    @ConditionalOnClass(value={Servlet.class})
    @ConditionalOnWebApplication(type=ConditionalOnWebApplication.Type.SERVLET)
    @AutoConfigureAfter(name={"org.springframework.boot.autoconfigure.security.SecurityFilterAutoConfiguration", "org.springframework.boot.autoconfigure.security.servlet.SecurityFilterAutoConfiguration"})
    static class TenantServletFilterConfiguration {
        private static final String FILTER_NAME = "tenantContextFilter";

        TenantServletFilterConfiguration() {
        }

        @Bean
        @ConditionalOnMissingBean(name={"tenantContextFilter"})
        public FilterRegistrationBean<TenantContextFilter> tenantContextFilter() {
            return this.createFilter(new TenantContextFilter(), FILTER_NAME, Integer.MIN_VALUE);
        }

        <T extends Filter> FilterRegistrationBean<T> createFilter(T filter, String filterName, int order) {
            FilterRegistrationBean registration = new FilterRegistrationBean(filter, new ServletRegistrationBean[0]);
            registration.setName(filterName);
            registration.setDispatcherTypes(DispatcherType.REQUEST, new DispatcherType[]{DispatcherType.ASYNC});
            registration.setOrder(order);
            return registration;
        }
    }
}

