/*
 * Decompiled with CFR 0.152.
 */
package com.power4j.fist.boot.web;

import com.power4j.fist.boot.web.AbstractPageRequestResolver;
import com.power4j.fist.data.domain.PageRequest;
import com.power4j.fist.data.domain.Pageable;
import jakarta.servlet.http.HttpServletRequest;
import java.util.Objects;
import org.springframework.core.MethodParameter;
import org.springframework.lang.Nullable;
import org.springframework.web.bind.support.WebDataBinderFactory;
import org.springframework.web.context.request.NativeWebRequest;
import org.springframework.web.method.support.ModelAndViewContainer;

public class PageRequestResolver
extends AbstractPageRequestResolver {
    public boolean supportsParameter(MethodParameter parameter) {
        return parameter.getParameterType().isAssignableFrom(Pageable.class);
    }

    @Nullable
    public Object resolveArgument(MethodParameter parameter, @Nullable ModelAndViewContainer mavContainer, NativeWebRequest webRequest, @Nullable WebDataBinderFactory binderFactory) throws Exception {
        HttpServletRequest request = (HttpServletRequest)webRequest.getNativeRequest(HttpServletRequest.class);
        if (Objects.isNull(request)) {
            return null;
        }
        int page = this.parseInt(request.getParameter(this.getPageNumberKey()), 1);
        int size = this.parseInt(request.getParameter(this.getPageSizeKey()), 20);
        return PageRequest.of((int)page, (int)size);
    }
}

