/*
 * Decompiled with CFR 0.152.
 */
package com.power4j.fist.boot.web.model;

import com.power4j.fist.boot.web.model.PageDTO;
import com.power4j.fist.data.domain.Paged;
import io.swagger.v3.oas.annotations.media.Schema;
import java.io.Serializable;
import java.util.Collections;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.springframework.util.Assert;

public class PageData<T>
implements Serializable {
    private static final long serialVersionUID = 1L;
    @Schema(description="\u6570\u636e")
    private final List<T> content;
    @Schema(description="\u603b\u884c\u6570")
    private final int total;
    @Schema(description="\u662f\u5426\u6709\u4e0b\u4e00\u9875")
    private final boolean hasNext;
    @Schema(description="\u9875\u7801")
    private final Integer pageNumber;
    @Schema(description="\u9875\u5927\u5c0f")
    private final Integer pageSize;

    public static <T> PageData<T> empty() {
        return new PageData(Collections.emptyList(), 0, false, 0, 0);
    }

    public static <T> PageData<T> of(List<T> content, int total, boolean hasNext, Integer pageNumber, Integer pageSize) {
        return new PageData<T>(content, total, hasNext, pageNumber, pageSize);
    }

    public static <T> PageData<T> of(Paged<T> paged) {
        long total = paged.getTotalElements();
        if (total < Integer.MIN_VALUE || total > Integer.MAX_VALUE) {
            throw new IllegalArgumentException(total + " cannot be cast to int value.");
        }
        return new PageData<T>(paged.getContent(), (int)total, paged.hasNext(), paged.getPageNumber(), paged.getPageSize());
    }

    public static <T> PageData<T> of(PageDTO<T> dto) {
        return new PageData<T>(dto.getContent(), dto.getTotal(), dto.getHasNext(), dto.getPageNumber(), dto.getPageSize());
    }

    public static <T> PageDTO<T> toPageDTO(PageData<T> src) {
        PageDTO<T> dto = new PageDTO<T>();
        dto.setContent(src.getContent());
        dto.setTotal(src.getTotal());
        dto.setHasNext(src.isHasNext());
        dto.setPageNumber(src.getPageNumber());
        dto.setPageSize(src.getPageSize());
        return dto;
    }

    public PageData(List<T> content, int total, boolean hasNext, Integer pageNumber, Integer pageSize) {
        this.content = content;
        this.total = total;
        this.hasNext = hasNext;
        this.pageNumber = pageNumber;
        this.pageSize = pageSize;
    }

    public List<T> getContent() {
        return this.content;
    }

    public int getTotal() {
        return this.total;
    }

    public boolean isHasNext() {
        return this.hasNext;
    }

    public Integer getPageNumber() {
        return this.pageNumber;
    }

    public Integer getPageSize() {
        return this.pageSize;
    }

    public <U> PageData<U> map(Function<? super T, ? extends U> converter) {
        return new PageData<U>(this.getConvertedContent(converter), this.total, this.hasNext, this.pageNumber, this.pageSize);
    }

    protected <U> List<U> getConvertedContent(Function<? super T, ? extends U> converter) {
        Assert.notNull(converter, (String)"Function must not be null!");
        return this.content.stream().map(converter).collect(Collectors.toList());
    }
}

