/*
 * Decompiled with CFR 0.152.
 */
package com.power4j.fist.boot.web.model;

import com.power4j.fist.data.domain.PageRequest;
import com.power4j.fist.data.domain.Sort;
import io.swagger.v3.oas.annotations.media.Schema;
import java.io.Serializable;
import lombok.Generated;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.lang.Nullable;

public class PageParameter
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final int DEFAULT_PAGE_SIZE = 20;
    public static final int FIRST_PAGE = 1;
    public static final String ORDER_VALUE_ASC = "ascend";
    public static final String ORDER_VALUE_DESC = "descend";
    @Schema(description="\u9875\u7801", defaultValue="1")
    private Integer pageNumber;
    @Schema(description="\u9875\u5927\u5c0f", defaultValue="20")
    private Integer pageSize;
    @Nullable
    @Schema(description="\u6392\u5e8f\u5b57\u6bb5")
    private String field;
    @Nullable
    @Schema(description="\u6392\u5e8f\u65b9\u5f0f ascend | descend")
    private String order;

    public static PageParameter of(int pageNumber, int pageSize) {
        return PageParameter.of(pageNumber, pageSize, null, null);
    }

    public static PageParameter of(int pageNumber, int pageSize, @Nullable String sortField, @Nullable String order) {
        PageParameter page = new PageParameter();
        page.setPageNumber(Math.max(pageNumber, 1));
        page.setPageSize(pageSize > 0 ? pageSize : 20);
        page.setField(sortField);
        page.setOrder(order);
        return page;
    }

    public PageParameter applyDefaultPage() {
        this.pageSize = this.getPageSizeOrDefault(20);
        this.pageNumber = this.getPageNumberOrDefault(1);
        return this;
    }

    public int getPageNumberOrDefault(int value) {
        int pn = (Integer)ObjectUtils.defaultIfNull((Object)this.pageNumber, (Object)value);
        if (pn < 1) {
            pn = 1;
        }
        return pn;
    }

    public int getPageSizeOrDefault(int value) {
        int ps = (Integer)ObjectUtils.defaultIfNull((Object)this.pageSize, (Object)value);
        if (ps < 0) {
            ps = 20;
        }
        return ps;
    }

    public PageRequest toPageRequest() {
        if (StringUtils.isNotEmpty((CharSequence)this.field)) {
            Sort.Direction direction = StringUtils.equalsIgnoreCase((CharSequence)this.order, (CharSequence)ORDER_VALUE_DESC) ? Sort.Direction.DESC : Sort.Direction.ASC;
            return PageRequest.of((int)this.pageNumber, (int)this.pageSize, (Sort)Sort.of((Sort.Direction)direction, (String[])new String[]{this.field}));
        }
        return PageRequest.of((int)this.pageNumber, (int)this.pageSize);
    }

    @Generated
    public PageParameter() {
    }

    @Generated
    public Integer getPageNumber() {
        return this.pageNumber;
    }

    @Generated
    public Integer getPageSize() {
        return this.pageSize;
    }

    @Nullable
    @Generated
    public String getField() {
        return this.field;
    }

    @Nullable
    @Generated
    public String getOrder() {
        return this.order;
    }

    @Generated
    public void setPageNumber(Integer pageNumber) {
        this.pageNumber = pageNumber;
    }

    @Generated
    public void setPageSize(Integer pageSize) {
        this.pageSize = pageSize;
    }

    @Generated
    public void setField(@Nullable String field) {
        this.field = field;
    }

    @Generated
    public void setOrder(@Nullable String order) {
        this.order = order;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PageParameter)) {
            return false;
        }
        PageParameter other = (PageParameter)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Integer this$pageNumber = this.getPageNumber();
        Integer other$pageNumber = other.getPageNumber();
        if (this$pageNumber == null ? other$pageNumber != null : !((Object)this$pageNumber).equals(other$pageNumber)) {
            return false;
        }
        Integer this$pageSize = this.getPageSize();
        Integer other$pageSize = other.getPageSize();
        if (this$pageSize == null ? other$pageSize != null : !((Object)this$pageSize).equals(other$pageSize)) {
            return false;
        }
        String this$field = this.getField();
        String other$field = other.getField();
        if (this$field == null ? other$field != null : !this$field.equals(other$field)) {
            return false;
        }
        String this$order = this.getOrder();
        String other$order = other.getOrder();
        return !(this$order == null ? other$order != null : !this$order.equals(other$order));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof PageParameter;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Integer $pageNumber = this.getPageNumber();
        result = result * 59 + ($pageNumber == null ? 43 : ((Object)$pageNumber).hashCode());
        Integer $pageSize = this.getPageSize();
        result = result * 59 + ($pageSize == null ? 43 : ((Object)$pageSize).hashCode());
        String $field = this.getField();
        result = result * 59 + ($field == null ? 43 : $field.hashCode());
        String $order = this.getOrder();
        result = result * 59 + ($order == null ? 43 : $order.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "PageParameter(pageNumber=" + this.getPageNumber() + ", pageSize=" + this.getPageSize() + ", field=" + this.getField() + ", order=" + this.getOrder() + ")";
    }
}

