/*
 * Decompiled with CFR 0.152.
 */
package com.power4j.fist.boot.autoconfigure.security;

import com.power4j.fist.boot.security.core.UserInfoSupplier;
import com.power4j.fist.boot.security.inner.DefaultUserCodec;
import com.power4j.fist.boot.security.inner.SecurityUtil;
import com.power4j.fist.boot.security.inner.TrustedUserFilter;
import com.power4j.fist.boot.security.inner.UserDecoder;
import java.util.List;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.annotation.Order;
import org.springframework.security.crypto.factory.PasswordEncoderFactories;
import org.springframework.security.crypto.password.PasswordEncoder;

@Configuration(proxyBeanMethods=false)
@ConditionalOnWebApplication(type=ConditionalOnWebApplication.Type.SERVLET)
public class InnerSecurityConfiguration {
    @Value(value="${fist.security.authentication.trusted.ip.whitelist:}")
    private List<String> whitelist;

    @Bean
    @ConditionalOnMissingBean(value={PasswordEncoder.class})
    public PasswordEncoder passwordEncoder() {
        return PasswordEncoderFactories.createDelegatingPasswordEncoder();
    }

    @Bean
    @ConditionalOnMissingBean
    public UserDecoder userDecoder() {
        return new DefaultUserCodec();
    }

    @Order(value=-2147483648)
    @Bean
    @ConditionalOnProperty(prefix="fist.security.authentication.trusted", name={"enabled"}, havingValue="true", matchIfMissing=true)
    public TrustedUserFilter trustedUserFilter(UserDecoder userDecoder) {
        TrustedUserFilter filter = new TrustedUserFilter(userDecoder);
        filter.setWhitelist(this.whitelist);
        return filter;
    }

    @Bean
    @ConditionalOnMissingBean
    public UserInfoSupplier userInfoSupplier() {
        return () -> SecurityUtil.getUser().orElse(null);
    }
}

