/*
 * Decompiled with CFR 0.152.
 */
package com.power4j.fist.security.oauth2.token;

import com.power4j.fist.boot.security.core.UserInfo;
import com.power4j.fist.boot.security.core.UserInfoExtractor;
import com.power4j.fist.boot.security.oauth2.Oauth2UserInfoExtractor;
import com.power4j.fist.security.core.authentication.UserConverter;
import com.power4j.fist.security.core.authorization.domain.AnonymousUser;
import com.power4j.fist.security.core.authorization.domain.AuthenticatedUser;
import com.power4j.fist.security.core.authorization.domain.GrantedPermission;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.lang3.reflect.TypeLiteral;
import org.apache.commons.lang3.reflect.Typed;
import org.springframework.security.core.Authentication;
import org.springframework.security.oauth2.server.resource.authentication.BearerTokenAuthentication;

public class DefaultUserConverter
implements UserConverter<AuthenticatedUser> {
    private UserInfoExtractor userInfoExtractor = new Oauth2UserInfoExtractor();

    @Override
    public AuthenticatedUser convert(Authentication authentication) {
        if (authentication instanceof BearerTokenAuthentication) {
            BearerTokenAuthentication auth = (BearerTokenAuthentication)authentication;
            return this.extractFromAttribute(auth.getTokenAttributes()).orElse(null);
        }
        return new AnonymousUser();
    }

    protected Optional<AuthenticatedUser> extractFromAttribute(Map<String, Object> prop) {
        return this.userInfoExtractor.extractAuthUser(prop).map(AuthenticatedUserAdapter::new);
    }

    @Generated
    public void setUserInfoExtractor(UserInfoExtractor userInfoExtractor) {
        this.userInfoExtractor = userInfoExtractor;
    }

    @Generated
    public UserInfoExtractor getUserInfoExtractor() {
        return this.userInfoExtractor;
    }

    public static class SimpleGrantedPermission
    implements GrantedPermission {
        private final String code;

        public SimpleGrantedPermission(String code) {
            this.code = code;
        }

        public String getPermissionCode() {
            return this.code;
        }
    }

    public static class AuthenticatedUserAdapter
    implements AuthenticatedUser {
        private final UserInfo userInfo;

        AuthenticatedUserAdapter(UserInfo userInfo) {
            this.userInfo = userInfo;
        }

        public String getUsername() {
            return this.userInfo.getUsername();
        }

        public String getTenantId() {
            return this.userInfo.getMetaProp("tenantId", String.class).orElse("N/A");
        }

        public Map<String, GrantedPermission> getPermissions() {
            TypeLiteral<Collection<String>> type = new TypeLiteral<Collection<String>>(){};
            return ((Collection)this.userInfo.getMetaProp("permissions", (Typed)type).orElse(Collections.emptyList())).stream().distinct().collect(Collectors.toMap(Function.identity(), SimpleGrantedPermission::new));
        }

        public Map<String, Object> getAdditionalInfo() {
            return Objects.requireNonNull(this.userInfo.getMeta());
        }
    }
}

