/*
 *  Copyright 2021 ChenJun (power4j@outlook.com & https://github.com/John-Chan)
 *
 *  Licensed under the GNU LESSER GENERAL PUBLIC LICENSE 3.0;
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *  <p>
 *  http://www.gnu.org/licenses/lgpl.html
 *  <p>
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */

package com.power4j.fist.boot.autoconfigure.common;

import com.power4j.fist.boot.autoconfigure.i18n.MessageConfiguration;
import com.power4j.fist.boot.autoconfigure.mon.AppMonConfiguration;
import com.power4j.fist.boot.common.jackson.JacksonConfig;
import com.power4j.fist.support.spring.util.ApplicationContextHolder;
import lombok.extern.slf4j.Slf4j;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.context.annotation.Import;

/**
 * @author CJ (power4j@outlook.com)
 * @date 2021/10/14
 * @since 1.0
 */
@Slf4j
@AutoConfiguration
@Import({ ApplicationContextHolder.class, MessageConfiguration.class, JacksonConfig.class, AppMonConfiguration.class })
public class CommonConfiguration {

}
