/*
 * Decompiled with CFR 0.152.
 */
package com.power4j.fist.boot.autoconfigure.i18n;

import com.power4j.fist.boot.common.error.Breaker;
import com.power4j.fist.boot.i18n.LocaleResolver;
import java.util.Objects;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.MessageSource;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.context.support.MessageSourceAccessor;
import org.springframework.context.support.ReloadableResourceBundleMessageSource;
import org.springframework.lang.Nullable;

@Configuration(proxyBeanMethods=false)
public class MessageConfiguration
implements InitializingBean {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(MessageConfiguration.class);
    @Nullable
    private LocaleResolver localeResolver;
    @Nullable
    private MessageSource messageSource;

    @Autowired(required=false)
    public void setLocaleResolver(@Nullable LocaleResolver localeResolver) {
        this.localeResolver = localeResolver;
    }

    @Autowired(required=false)
    public void setMessageSource(@Nullable MessageSource messageSource) {
        this.messageSource = messageSource;
    }

    private MessageSource buildInMessageSource() {
        ReloadableResourceBundleMessageSource messageSource = new ReloadableResourceBundleMessageSource();
        messageSource.setBasenames(new String[]{"classpath:messages/messages"});
        return messageSource;
    }

    public void afterPropertiesSet() throws Exception {
        MessageSource msgSource;
        LocaleResolver resolver = this.localeResolver;
        if (Objects.isNull(resolver)) {
            resolver = LocaleContextHolder::getLocale;
        }
        if (Objects.isNull(msgSource = this.messageSource)) {
            msgSource = this.buildInMessageSource();
        }
        Breaker.setLocaleResolver((LocaleResolver)resolver);
        Breaker.setMessageSourceAccessor((MessageSourceAccessor)new MessageSourceAccessor(msgSource));
    }

    @Generated
    public MessageConfiguration() {
    }
}

