/*
 * Decompiled with CFR 0.152.
 */
package com.power4j.fist.boot.autoconfigure.mon;

import com.power4j.fist.boot.mon.ApiDescriptionResolver;
import com.power4j.fist.boot.mon.SmartApiDescriptionResolver;
import com.power4j.fist.boot.mon.aspect.ApiLogAspect;
import com.power4j.fist.boot.mon.aspect.ReportErrorAspect;
import com.power4j.fist.boot.mon.event.ApiLogEvent;
import com.power4j.fist.boot.mon.event.ServerErrorEvent;
import com.power4j.fist.boot.mon.info.DefaultExceptionTranslator;
import com.power4j.fist.boot.mon.info.ExceptionTranslator;
import com.power4j.fist.boot.mon.listener.AbstractEventListener;
import com.power4j.fist.boot.mon.listener.DefaultApiLogEventListener;
import com.power4j.fist.boot.mon.listener.DefaultServerErrorEventListener;
import com.power4j.fist.boot.security.core.UserInfoAccessor;
import java.util.Objects;
import org.aspectj.lang.Aspects;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.MessageSource;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.support.MessageSourceAccessor;

@Configuration(proxyBeanMethods=false)
public class AppMonConfiguration {
    @Bean
    @ConditionalOnClass(value={Aspects.class})
    public ReportErrorAspect reportErrorAspect() {
        return new ReportErrorAspect();
    }

    @Bean
    @ConditionalOnMissingBean(value={ServerErrorEvent.class}, parameterizedContainer={AbstractEventListener.class})
    public DefaultServerErrorEventListener defaultServerErrorEventListener() {
        return new DefaultServerErrorEventListener();
    }

    @Bean
    @ConditionalOnMissingBean(value={ExceptionTranslator.class})
    public ExceptionTranslator defaultExceptionTranslator(ObjectProvider<MessageSource> messageSourceObjectProvider) {
        MessageSource source = (MessageSource)messageSourceObjectProvider.getIfAvailable();
        MessageSourceAccessor messageSourceAccessor = Objects.nonNull(source) ? new MessageSourceAccessor(source) : null;
        return new DefaultExceptionTranslator(messageSourceAccessor);
    }

    @Bean
    @ConditionalOnClass(value={Aspects.class})
    @ConditionalOnProperty(prefix="fist.mon.api-log", name={"enabled"}, matchIfMissing=true)
    public ApiLogAspect apiLogAspect(ExceptionTranslator translator, ObjectProvider<UserInfoAccessor> userInfoAccessor) {
        return new ApiLogAspect((ApiDescriptionResolver)new SmartApiDescriptionResolver(), translator, (UserInfoAccessor)userInfoAccessor.getIfAvailable());
    }

    @Bean
    @ConditionalOnBean(value={ApiLogAspect.class})
    @ConditionalOnMissingBean(value={ApiLogEvent.class}, parameterizedContainer={AbstractEventListener.class})
    public DefaultApiLogEventListener defaultApiLogEventListener() {
        return new DefaultApiLogEventListener();
    }
}

