/*
 * Decompiled with CFR 0.152.
 */
package com.power4j.fist.boot.autoconfigure.web;

import com.power4j.fist.boot.mon.info.TraceInfo;
import com.power4j.fist.boot.mon.info.TraceInfoResolver;
import com.power4j.fist.boot.web.servlet.mvc.formatter.LocalDateFormatter;
import com.power4j.fist.boot.web.servlet.mvc.formatter.LocalDateTimeFormatter;
import com.power4j.fist.boot.web.servlet.mvc.formatter.LocalTimeFormatter;
import com.power4j.fist.boot.web.servlet.mvc.formatter.MonthDayFormatter;
import com.power4j.fist.boot.web.servlet.mvc.formatter.YearMonthFormatter;
import com.power4j.fist.support.spring.web.servlet.util.HttpServletRequestUtil;
import jakarta.servlet.http.HttpServletRequest;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.MonthDay;
import java.time.YearMonth;
import java.util.Optional;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.annotation.Configuration;
import org.springframework.format.Formatter;
import org.springframework.format.FormatterRegistry;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurer;

@AutoConfiguration
@ComponentScan(basePackages={"com.power4j.fist.boot.web.servlet.error"})
@ConditionalOnWebApplication(type=ConditionalOnWebApplication.Type.SERVLET)
public class FistWebAutoConfiguration {
    @Bean
    @ConditionalOnMissingBean(value={HttpServletRequest.class}, parameterizedContainer={TraceInfoResolver.class})
    public TraceInfoResolver<HttpServletRequest> requestTraceInfoResolver() {
        return request -> {
            String reqId = HttpServletRequestUtil.getHeader((HttpServletRequest)request, (String)"X-REQ-UID").orElse(null);
            TraceInfo info = new TraceInfo();
            info.setRequestId(reqId);
            return Optional.of(info);
        };
    }

    @Configuration
    public static class WebMvcConfig
    implements WebMvcConfigurer {
        public void addFormatters(FormatterRegistry registry) {
            registry.addFormatterForFieldType(YearMonth.class, (Formatter)new YearMonthFormatter());
            registry.addFormatterForFieldType(MonthDay.class, (Formatter)new MonthDayFormatter());
            registry.addFormatterForFieldType(LocalDate.class, (Formatter)new LocalDateFormatter());
            registry.addFormatterForFieldType(LocalTime.class, (Formatter)new LocalTimeFormatter());
            registry.addFormatterForFieldType(LocalDateTime.class, (Formatter)new LocalDateTimeFormatter());
        }
    }
}

