/*
 * Decompiled with CFR 0.152.
 */
package com.power4j.fist.boot.common.jackson;

import com.fasterxml.jackson.databind.AnnotationIntrospector;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.introspect.AnnotationIntrospectorPair;
import com.power4j.fist.boot.common.jackson.JacksonCustomizeProperties;
import com.power4j.fist.boot.common.jackson.module.DateTimeModule;
import com.power4j.fist.boot.common.jackson.module.NumberStrModule;
import com.power4j.fist.jackson.support.obfuscation.ObfuscatedAnnotationIntrospector;
import java.time.ZoneId;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.AutoConfigureBefore;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.jackson.Jackson2ObjectMapperBuilderCustomizer;
import org.springframework.boot.autoconfigure.jackson.JacksonAutoConfiguration;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.annotation.Order;
import org.springframework.http.converter.json.Jackson2ObjectMapperBuilder;

@Configuration(proxyBeanMethods=false)
@ConditionalOnClass(value={ObjectMapper.class})
@ConditionalOnProperty(prefix="fist.jackson.customize", name={"enabled"}, matchIfMissing=true)
@EnableConfigurationProperties(value={JacksonCustomizeProperties.class})
@AutoConfigureBefore(value={JacksonAutoConfiguration.class})
public class JacksonConfig {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(JacksonConfig.class);
    private final JacksonCustomizeProperties jacksonCustomizeProperties;
    private static final Map<JacksonCustomizeProperties.ModuleName, Module> MODULE_MAP = new HashMap<JacksonCustomizeProperties.ModuleName, Module>(2);

    @Bean
    @Order(value=10000)
    public Jackson2ObjectMapperBuilderCustomizer customizer() {
        return builder -> {
            builder.locale(Locale.CHINA);
            this.applyTimeZone(builder);
            this.applySimpleDateFormat(builder);
            this.applyModules(builder);
            if (this.jacksonCustomizeProperties.isObfuscatedSupport()) {
                this.applyExtra(builder);
            }
        };
    }

    private void applyTimeZone(Jackson2ObjectMapperBuilder builder) {
        String timeZoneId = this.jacksonCustomizeProperties.getTimeZoneId();
        if (StringUtils.isEmpty((CharSequence)timeZoneId)) {
            return;
        }
        log.info("Set time zone :{}", (Object)timeZoneId);
        if ("system".equalsIgnoreCase(timeZoneId)) {
            builder.timeZone(TimeZone.getTimeZone(ZoneId.systemDefault()));
            return;
        }
        builder.timeZone(TimeZone.getTimeZone(ZoneId.of(timeZoneId)));
    }

    private void applySimpleDateFormat(Jackson2ObjectMapperBuilder builder) {
        String format = this.jacksonCustomizeProperties.getSimpleDateFormat();
        if (!StringUtils.isEmpty((CharSequence)format)) {
            log.info("Set simple date format :{}", (Object)format);
            builder.simpleDateFormat(format);
        }
    }

    private void applyModules(Jackson2ObjectMapperBuilder builder) {
        List excludeModules = (List)ObjectUtils.defaultIfNull(this.jacksonCustomizeProperties.getExcludeModules(), Collections.emptyList());
        List<Module> modules = MODULE_MAP.entrySet().stream().filter(kv -> !excludeModules.contains(kv.getKey())).map(Map.Entry::getValue).toList();
        if (!modules.isEmpty()) {
            List names = modules.stream().map(Module::getModuleName).collect(Collectors.toList());
            log.info("Install modules: {}", names);
            builder.modulesToInstall(l -> l.addAll(modules));
        }
    }

    private void applyExtra(Jackson2ObjectMapperBuilder builder) {
        log.info("Install extra Serializer/Deserializer");
        builder.annotationIntrospector(introspector -> {
            if (null != introspector) {
                return AnnotationIntrospectorPair.pair((AnnotationIntrospector)introspector, (AnnotationIntrospector)new ObfuscatedAnnotationIntrospector());
            }
            return new ObfuscatedAnnotationIntrospector();
        });
    }

    @Generated
    public JacksonConfig(JacksonCustomizeProperties jacksonCustomizeProperties) {
        this.jacksonCustomizeProperties = jacksonCustomizeProperties;
    }

    static {
        MODULE_MAP.put(JacksonCustomizeProperties.ModuleName.Date, (Module)new DateTimeModule());
        MODULE_MAP.put(JacksonCustomizeProperties.ModuleName.NumberToStr, (Module)new NumberStrModule());
    }
}

