/*
 * Decompiled with CFR 0.152.
 */
package com.power4j.fist.cloud.autoconfigure.rpc.feign.error;

import com.power4j.coca.kit.common.lang.Result;
import com.power4j.fist.boot.i18n.LocaleResolver;
import com.power4j.fist.boot.web.servlet.error.AbstractExceptionHandler;
import feign.FeignException;
import java.util.Locale;
import java.util.Objects;
import java.util.Optional;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.MessageSource;
import org.springframework.context.support.MessageSourceAccessor;
import org.springframework.core.annotation.Order;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.lang.Nullable;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.RestControllerAdvice;

@Order(value=5000)
@RestControllerAdvice
public class FeignErrorHandler
extends AbstractExceptionHandler {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(FeignErrorHandler.class);
    @Nullable
    private MessageSourceAccessor messageSourceAccessor;
    @Nullable
    private LocaleResolver localeResolver;

    @Autowired(required=false)
    public void setMessageSource(MessageSource messageSource) {
        this.messageSourceAccessor = new MessageSourceAccessor(messageSource);
    }

    @Autowired(required=false)
    public void setLocaleResolver(@Nullable LocaleResolver localeResolver) {
        this.localeResolver = localeResolver;
    }

    protected String translateMessage(String msgKey, Object ... args) {
        Locale locale = Optional.ofNullable(this.localeResolver).map(LocaleResolver::resolve).orElse(Locale.CHINA);
        if (Objects.nonNull(this.messageSourceAccessor)) {
            return this.messageSourceAccessor.getMessage(msgKey, args, msgKey, locale);
        }
        return msgKey;
    }

    protected Result<?> translate(FeignException e) {
        int status = e.status();
        if (status >= 400 && status < 500) {
            return Result.create((String)"C0110", (String)this.translateMessage("common.rpc.err-request", new Object[0]), null);
        }
        if (status >= 500 && status <= 599) {
            return Result.create((String)"C0110", (String)this.translateMessage("common.rpc.err-retry", new Object[0]), null);
        }
        return Result.create((String)"B0001", (String)this.translateMessage("common.server.fail-retry", new Object[0]), null);
    }

    @ExceptionHandler(value={FeignException.class})
    public ResponseEntity<Result<?>> handleException(FeignException e) {
        log.error("\u63a5\u53e3\u8c03\u7528\u51fa\u9519({}). {}", (Object)e.getClass().getSimpleName(), (Object)e.getMessage());
        return ResponseEntity.status((HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR).body(this.translate(e));
    }
}

