/*
 * Decompiled with CFR 0.152.
 */
package com.power4j.fist.cloud.rpc.feign;

import com.power4j.fist.boot.security.context.UserContextHolder;
import feign.RequestInterceptor;
import feign.RequestTemplate;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UserRelayInterceptor
implements RequestInterceptor {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(UserRelayInterceptor.class);

    public void apply(RequestTemplate template) {
        List tokens = Optional.ofNullable((Collection)template.headers().get("X-USER-IN")).map(l -> l.stream().filter(StringUtils::isNotEmpty).collect(Collectors.toList())).orElse(Collections.emptyList());
        if (!tokens.isEmpty()) {
            UserContextHolder.getOriginalValue().ifPresent(v -> {
                if (log.isTraceEnabled()) {
                    log.trace("\u4f20\u9012 {} :{}", (Object)"X-USER-IN", v);
                }
                template.headers().put("X-USER-IN", Collections.singletonList(v));
            });
        } else if (log.isTraceEnabled()) {
            String pre = StringUtils.join(tokens, (String)",");
            log.trace("{} \u5df2\u7ecf\u5b58\u5728:{}", (Object)"X-USER-IN", (Object)pre);
        }
    }
}

