/*
 * Decompiled with CFR 0.152.
 */
package com.power4j.fist.jackson.support.obfuscation;

import com.fasterxml.jackson.core.JacksonException;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.BeanProperty;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.deser.ContextualDeserializer;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.fasterxml.jackson.databind.deser.std.StringDeserializer;
import com.power4j.fist.jackson.annotation.Obfuscation;
import com.power4j.fist.jackson.support.obfuscation.SimpleStringObfuscate;
import com.power4j.fist.jackson.support.obfuscation.StringObfuscate;
import com.power4j.fist.jackson.support.obfuscation.StringObfuscateRegistry;
import java.io.IOException;
import java.util.Optional;

public class ObfuscatedStringDeserializer
extends StdDeserializer<String>
implements ContextualDeserializer {
    private final StringObfuscate obfuscate;

    public ObfuscatedStringDeserializer() {
        super(String.class);
        this.obfuscate = SimpleStringObfuscate.ofDefault();
    }

    protected ObfuscatedStringDeserializer(StringObfuscate obfuscate) {
        super(String.class);
        this.obfuscate = obfuscate;
    }

    public String deserialize(JsonParser p, DeserializationContext ctx) throws IOException, JacksonException {
        String value = p.getValueAsString();
        if (value == null) {
            return null;
        }
        if (!value.startsWith(this.obfuscate.algorithm() + ".")) {
            return value;
        }
        value = value.substring(this.obfuscate.algorithm().length() + 1);
        try {
            return this.obfuscate.deobfuscate(value);
        }
        catch (Exception e) {
            throw new JsonParseException(p, e.getMessage(), (Throwable)e);
        }
    }

    public JsonDeserializer<?> createContextual(DeserializationContext ctx, BeanProperty property) throws JsonMappingException {
        if (property == null) {
            return StringDeserializer.instance;
        }
        Obfuscation annotation = (Obfuscation)property.getAnnotation(Obfuscation.class);
        if (annotation == null) {
            return StringDeserializer.instance;
        }
        Class<? extends StringObfuscate> obfuscate = annotation.processor();
        Optional<StringObfuscate> processor = StringObfuscateRegistry.getObfuscateInstance(obfuscate);
        if (processor.isEmpty()) {
            throw new IllegalStateException(String.format("Obfuscation processor not registered: %s", annotation.processor().getName()));
        }
        return new ObfuscatedStringDeserializer(processor.get());
    }
}

