/*
 * Decompiled with CFR 0.152.
 */
package com.power4j.fist.jackson.support.obfuscation;

import com.fasterxml.jackson.core.JsonGenerationException;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.BeanProperty;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.ser.ContextualSerializer;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import com.power4j.fist.jackson.annotation.Obfuscation;
import com.power4j.fist.jackson.support.obfuscation.SimpleStringObfuscate;
import com.power4j.fist.jackson.support.obfuscation.StringObfuscate;
import com.power4j.fist.jackson.support.obfuscation.StringObfuscateRegistry;
import java.io.IOException;
import java.util.Optional;

public class ObfuscatedStringSerializer
extends StdSerializer<String>
implements ContextualSerializer {
    private final StringObfuscate obfuscate;

    public ObfuscatedStringSerializer() {
        super(String.class);
        this.obfuscate = SimpleStringObfuscate.ofDefault();
    }

    public ObfuscatedStringSerializer(StringObfuscate obfuscate) {
        super(String.class);
        this.obfuscate = obfuscate;
    }

    public void serialize(String value, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) throws IOException {
        if (value == null) {
            jsonGenerator.writeNull();
        } else if (value.isEmpty()) {
            jsonGenerator.writeString(value);
        } else {
            String obfuscated;
            try {
                obfuscated = this.obfuscate.algorithm() + "." + this.obfuscate.obfuscate(value);
            }
            catch (Exception e) {
                throw new JsonGenerationException((Throwable)e, jsonGenerator);
            }
            jsonGenerator.writeString(obfuscated);
        }
    }

    public JsonSerializer<?> createContextual(SerializerProvider prov, BeanProperty property) throws JsonMappingException {
        if (property == null) {
            return prov.findNullValueSerializer(property);
        }
        Obfuscation annotation = (Obfuscation)property.getAnnotation(Obfuscation.class);
        if (annotation == null) {
            return prov.findContentValueSerializer(property.getType(), property);
        }
        Class<? extends StringObfuscate> obfuscate = annotation.processor();
        Optional<StringObfuscate> processor = StringObfuscateRegistry.getObfuscateInstance(obfuscate);
        if (processor.isEmpty()) {
            throw new IllegalStateException(String.format("Obfuscation processor not registered: %s", annotation.processor().getName()));
        }
        return new ObfuscatedStringSerializer(processor.get());
    }
}

