/*
 * Decompiled with CFR 0.152.
 */
package com.power4j.fist.jackson.support.obfuscation;

import com.power4j.fist.jackson.support.obfuscation.StringObfuscate;
import java.nio.charset.StandardCharsets;
import java.util.Base64;

public class SimpleStringObfuscate
implements StringObfuscate {
    public static final String ALGORITHM = "OBF.XOR_V1";
    private final Base64.Encoder ENCODER = Base64.getEncoder();
    private final Base64.Decoder DECODER = Base64.getDecoder();
    private final byte[] key;

    public static SimpleStringObfuscate ofDefault() {
        return new SimpleStringObfuscate(new byte[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15});
    }

    public SimpleStringObfuscate(byte[] key) {
        this.key = key;
    }

    @Override
    public String algorithm() {
        return ALGORITHM;
    }

    @Override
    public String obfuscate(String value) {
        if (value.isEmpty()) {
            return value;
        }
        byte[] bytes = value.getBytes(StandardCharsets.UTF_8);
        byte[] result = new byte[bytes.length];
        for (int i = 0; i < bytes.length; ++i) {
            result[i] = (byte)(bytes[i] ^ this.key[i % this.key.length]);
        }
        return this.ENCODER.encodeToString(result);
    }

    @Override
    public String deobfuscate(String value) throws Exception {
        byte[] bytes;
        if (value.isEmpty()) {
            return value;
        }
        try {
            bytes = this.DECODER.decode(value);
        }
        catch (IllegalArgumentException e) {
            throw new IllegalStateException("Base64 decode error", e);
        }
        byte[] result = new byte[bytes.length];
        for (int i = 0; i < bytes.length; ++i) {
            result[i] = (byte)(bytes[i] ^ this.key[i % this.key.length]);
        }
        return new String(result, StandardCharsets.UTF_8);
    }
}

