/*
 * Decompiled with CFR 0.152.
 */
package com.power4j.fist.boot.common.utils;

import java.lang.reflect.Array;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.lang3.reflect.TypeUtils;
import org.apache.commons.lang3.reflect.Typed;
import org.springframework.lang.Nullable;

public final class MapKit {
    public static <K, T> Optional<T> useValue(@Nullable Map<? extends K, ?> map, K key, Typed<T> typed) {
        return Optional.ofNullable(map).map(m -> m.get(key)).map(value -> {
            Type type = typed.getType();
            if (!TypeUtils.isInstance((Object)value, (Type)type)) {
                String msg = String.format("Can not cast %s to %s", value.getClass().getName(), type.getTypeName());
                throw new ClassCastException(msg);
            }
            return value;
        });
    }

    public static <K, V, R> List<R> readAsList(@Nullable Map<K, V> map, K key, Function<Object, R> mapper) {
        return Optional.ofNullable(map).map(m -> m.get(key)).map(value -> {
            if (value instanceof Collection) {
                return ((Collection)value).stream().map(mapper).collect(Collectors.toList());
            }
            if (value.getClass().isArray()) {
                int length = Array.getLength(value);
                ArrayList list = new ArrayList(length);
                for (int i = 0; i < length; ++i) {
                    Object arrayElement = Array.get(value, i);
                    list.add(mapper.apply(arrayElement));
                }
                return list;
            }
            return Collections.singletonList(mapper.apply(value));
        }).orElseGet(Collections::emptyList);
    }

    public static <K, V, R> Set<R> readAsSet(@Nullable Map<K, V> map, K key, Function<Object, R> mapper) {
        return new HashSet<R>(MapKit.readAsList(map, key, mapper));
    }

    @Generated
    private MapKit() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

