/*
 * Decompiled with CFR 0.152.
 */
package com.power4j.fist.boot.security.core;

import com.power4j.fist.boot.common.utils.MapKit;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import lombok.Generated;
import org.apache.commons.lang3.reflect.Typed;
import org.springframework.lang.Nullable;

public class UserInfo
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Long userId;
    private String username;
    @Nullable
    private String nickName;
    @Nullable
    private String avatarUrl;
    @Nullable
    private Map<String, Object> meta;

    public <T> Optional<T> getMetaProp(String key, Class<T> clazz) {
        return this.getRawMetaProp(key).map(clazz::cast);
    }

    public <T> Optional<T> getMetaProp(String key, Typed<T> typed) {
        return MapKit.useValue(this.meta, key, typed);
    }

    public Optional<Object> getRawMetaProp(String key) {
        if (Objects.isNull(this.meta) || !this.meta.containsKey(key)) {
            return Optional.empty();
        }
        return Optional.ofNullable(this.meta.get(key));
    }

    @Nullable
    public Object putMetaProp(String key, Object value) {
        return this.useMeta().put(key, value);
    }

    @Nullable
    public Object putMetaPropIfAbsent(String key, Object value) {
        return this.useMeta().putIfAbsent(key, value);
    }

    private Map<String, Object> useMeta() {
        if (Objects.isNull(this.meta)) {
            this.meta = new HashMap<String, Object>(8);
        }
        return this.meta;
    }

    public Map<String, Object> getMeta() {
        return this.useMeta();
    }

    @Generated
    public UserInfo() {
    }

    @Generated
    public Long getUserId() {
        return this.userId;
    }

    @Generated
    public String getUsername() {
        return this.username;
    }

    @Nullable
    @Generated
    public String getNickName() {
        return this.nickName;
    }

    @Nullable
    @Generated
    public String getAvatarUrl() {
        return this.avatarUrl;
    }

    @Generated
    public void setUserId(Long userId) {
        this.userId = userId;
    }

    @Generated
    public void setUsername(String username) {
        this.username = username;
    }

    @Generated
    public void setNickName(@Nullable String nickName) {
        this.nickName = nickName;
    }

    @Generated
    public void setAvatarUrl(@Nullable String avatarUrl) {
        this.avatarUrl = avatarUrl;
    }

    @Generated
    public void setMeta(@Nullable Map<String, Object> meta) {
        this.meta = meta;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof UserInfo)) {
            return false;
        }
        UserInfo other = (UserInfo)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Long this$userId = this.getUserId();
        Long other$userId = other.getUserId();
        if (this$userId == null ? other$userId != null : !((Object)this$userId).equals(other$userId)) {
            return false;
        }
        String this$username = this.getUsername();
        String other$username = other.getUsername();
        if (this$username == null ? other$username != null : !this$username.equals(other$username)) {
            return false;
        }
        String this$nickName = this.getNickName();
        String other$nickName = other.getNickName();
        if (this$nickName == null ? other$nickName != null : !this$nickName.equals(other$nickName)) {
            return false;
        }
        String this$avatarUrl = this.getAvatarUrl();
        String other$avatarUrl = other.getAvatarUrl();
        if (this$avatarUrl == null ? other$avatarUrl != null : !this$avatarUrl.equals(other$avatarUrl)) {
            return false;
        }
        Map<String, Object> this$meta = this.getMeta();
        Map<String, Object> other$meta = other.getMeta();
        return !(this$meta == null ? other$meta != null : !((Object)this$meta).equals(other$meta));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof UserInfo;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $userId = this.getUserId();
        result = result * 59 + ($userId == null ? 43 : ((Object)$userId).hashCode());
        String $username = this.getUsername();
        result = result * 59 + ($username == null ? 43 : $username.hashCode());
        String $nickName = this.getNickName();
        result = result * 59 + ($nickName == null ? 43 : $nickName.hashCode());
        String $avatarUrl = this.getAvatarUrl();
        result = result * 59 + ($avatarUrl == null ? 43 : $avatarUrl.hashCode());
        Map<String, Object> $meta = this.getMeta();
        result = result * 59 + ($meta == null ? 43 : ((Object)$meta).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "UserInfo(userId=" + this.getUserId() + ", username=" + this.getUsername() + ", nickName=" + this.getNickName() + ", avatarUrl=" + this.getAvatarUrl() + ", meta=" + this.getMeta() + ")";
    }
}

