/*
 * Decompiled with CFR 0.152.
 */
package com.power4j.fist.boot.common.op;

import com.power4j.fist.boot.common.op.OpHandler;
import com.power4j.fist.boot.common.op.OpTemplate;
import com.power4j.fist.boot.common.op.OpTemplateBuilder;
import com.power4j.fist.boot.common.op.OpTemplateConfigure;
import com.power4j.fist.boot.common.op.OpTemplateException;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public abstract class AbstractOpTemplateRegistry<T> {
    private final Map<String, OpTemplate<T>> definitions;

    public AbstractOpTemplateRegistry(List<OpHandler<T>> handlers, List<OpTemplateConfigure<T, OpTemplateBuilder<T>>> configures) {
        this.definitions = this.buildMap(handlers, configures);
    }

    public OpTemplate<T> use(String id) {
        if (!this.definitions.containsKey(id)) {
            throw new OpTemplateException("OpTemplate not defined :" + id);
        }
        return this.definitions.get(id);
    }

    private Map<String, OpTemplate<T>> buildMap(List<OpHandler<T>> handlers, List<OpTemplateConfigure<T, OpTemplateBuilder<T>>> configures) {
        Objects.requireNonNull(handlers);
        OpTemplateBuilder builder = new OpTemplateBuilder(handlers);
        configures.forEach(c -> c.config(builder));
        return builder.build();
    }
}

