/*
 * Decompiled with CFR 0.152.
 */
package com.power4j.fist.boot.common.op;

import com.power4j.fist.boot.common.op.HandlerCompose;
import com.power4j.fist.boot.common.op.OpHandler;
import com.power4j.fist.boot.common.op.OpTemplate;
import com.power4j.fist.boot.common.op.OpTemplateException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.apache.commons.lang3.Validate;
import org.springframework.lang.Nullable;

public class OpTemplateBuilder<T> {
    private final int cpuCore = Runtime.getRuntime().availableProcessors();
    private final List<OpHandler<T>> knownHandlers;
    private final Map<String, List<HandlerInfo<T>>> preHandlerMap = new ConcurrentHashMap<String, List<HandlerInfo<T>>>(2);
    private final Map<String, List<HandlerInfo<T>>> postHandlerMap = new ConcurrentHashMap<String, List<HandlerInfo<T>>>(2);
    @Nullable
    private List<HandlerInfo<T>> entry;
    @Nullable
    private String currentId;
    private ExecutorService asyncExecutor = this.createExecutorService(this.cpuCore * 2);

    public OpTemplateBuilder(List<OpHandler<T>> knownHandlers) {
        this.knownHandlers = Objects.requireNonNull(knownHandlers);
    }

    public OpTemplateBuilder() {
        this(Collections.emptyList());
    }

    public OpTemplateBuilder<T> asyncExecutor(ExecutorService executorService) {
        this.asyncExecutor = executorService;
        return this;
    }

    public OpTemplateBuilder<T> pre() {
        this.entry = this.preHandlerMap.get(this.checkoutCurrentId());
        return this;
    }

    public OpTemplateBuilder<T> post() {
        this.entry = this.postHandlerMap.get(this.checkoutCurrentId());
        return this;
    }

    public OpTemplateBuilder<T> add(OpHandler<T> handler) {
        Validate.notNull(handler);
        this.checkoutCurrentEntry().add(HandlerInfo.of(handler, false));
        return this;
    }

    public OpTemplateBuilder<T> addAsync(OpHandler<T> handler) {
        Validate.notNull(handler);
        this.checkoutCurrentEntry().add(HandlerInfo.of(handler, true));
        return this;
    }

    public OpTemplateBuilder<T> add(Class<? extends OpHandler<T>> clazz) {
        Validate.notNull(clazz);
        this.checkoutCurrentEntry().add(HandlerInfo.of(clazz, false));
        return this;
    }

    public OpTemplateBuilder<T> addAsync(Class<? extends OpHandler<T>> clazz) {
        Validate.notNull(clazz);
        this.checkoutCurrentEntry().add(HandlerInfo.of(clazz, true));
        return this;
    }

    public OpTemplateBuilder<T> define(String id) {
        this.currentId = id;
        this.entry = null;
        this.preHandlerMap.putIfAbsent(id, new ArrayList(2));
        this.postHandlerMap.putIfAbsent(id, new ArrayList(2));
        return this;
    }

    public Map<String, OpTemplate<T>> build() {
        HashSet<String> idSet = new HashSet<String>(this.preHandlerMap.keySet());
        idSet.addAll(this.postHandlerMap.keySet());
        Map<String, OpTemplate<T>> map = idSet.stream().collect(Collectors.toMap(o -> o, this::buildTemplate));
        this.entry = null;
        this.currentId = null;
        return map;
    }

    private OpTemplate<T> buildTemplate(String id) {
        HandlerCompose<T> pre = new HandlerCompose<T>(this.prepareHandlerList(this.preHandlerMap.getOrDefault(id, Collections.emptyList())));
        HandlerCompose<T> post = new HandlerCompose<T>(this.prepareHandlerList(this.postHandlerMap.getOrDefault(id, Collections.emptyList())));
        return new OpTemplate<T>(Objects.requireNonNull(this.currentId), pre, post);
    }

    private List<HandlerInfo<T>> checkoutCurrentEntry() {
        if (Objects.isNull(this.entry)) {
            throw new IllegalStateException("Please call pre() or post() first");
        }
        return this.entry;
    }

    private String checkoutCurrentId() {
        if (Objects.isNull(this.currentId)) {
            throw new IllegalStateException("Please call define() first");
        }
        return this.currentId;
    }

    private List<OpHandler<T>> prepareHandlerList(List<HandlerInfo<T>> infoList) {
        return infoList.stream().map(info -> {
            OpHandler handler = Optional.ofNullable(info.getHandler()).orElseGet(() -> this.findHandler(info.getHandlerClass()));
            if (null == handler) {
                throw new OpTemplateException("No handler of " + info.getHandlerClass());
            }
            if (info.isAsync()) {
                return context -> this.asyncExecutor.execute(() -> handler.handle(context));
            }
            return handler;
        }).collect(Collectors.toList());
    }

    @Nullable
    private OpHandler<T> findHandler(@Nullable Class<? extends OpHandler<T>> clazz) {
        if (null == clazz) {
            return null;
        }
        return this.knownHandlers.stream().filter(h -> clazz.isAssignableFrom(h.getClass())).findFirst().orElse(null);
    }

    private ExecutorService createExecutorService(int threads) {
        return new ThreadPoolExecutor(threads, threads, 0L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>());
    }

    static class HandlerInfo<T> {
        @Nullable
        private final Class<? extends OpHandler<T>> handlerClass;
        @Nullable
        private final OpHandler<T> handler;
        private final boolean async;

        static <T> HandlerInfo<T> of(Class<? extends OpHandler<T>> handlerClass, boolean async) {
            return new HandlerInfo<T>(handlerClass, async);
        }

        static <T> HandlerInfo<T> of(OpHandler<T> handler, boolean async) {
            return new HandlerInfo<T>(handler, async);
        }

        HandlerInfo(Class<? extends OpHandler<T>> handlerClass, boolean async) {
            this.handlerClass = handlerClass;
            this.handler = null;
            this.async = async;
        }

        HandlerInfo(OpHandler<T> handler, boolean async) {
            this.handlerClass = null;
            this.handler = handler;
            this.async = async;
        }

        @Nullable
        public OpHandler<T> getHandler() {
            return this.handler;
        }

        @Nullable
        public Class<? extends OpHandler<T>> getHandlerClass() {
            return this.handlerClass;
        }

        public boolean isAsync() {
            return this.async;
        }
    }
}

