/*
 * Decompiled with CFR 0.152.
 */
package com.power4j.fist.data.constant;

import com.power4j.fist.data.constant.Enabled;
import java.util.function.Function;

public enum YesNo {
    Y("1"),
    N("0");

    private final String value;

    private YesNo(String value) {
        this.value = value;
    }

    public String getValue() {
        return this.value;
    }

    public static boolean yes(String str) {
        return Y.getValue().equals(str);
    }

    public static boolean not(String str) {
        return N.getValue().equals(str);
    }

    public static Enabled parseOrDefault(String value, Enabled defValue) {
        if (value == null) {
            return defValue;
        }
        for (Enabled o : Enabled.values()) {
            if (!o.getValue().equals(value)) continue;
            return o;
        }
        return defValue;
    }

    public static Enabled parseOrNull(String value) {
        return YesNo.parseOrDefault(value, null);
    }

    public static Enabled parseOrThrow(String value, Function<String, RuntimeException> thrower) {
        Enabled o = YesNo.parseOrDefault(value, null);
        if (o == null) {
            throw thrower.apply(value);
        }
        return o;
    }

    public static Enabled parse(String value) throws IllegalArgumentException {
        return YesNo.parseOrThrow(value, v -> new IllegalArgumentException("Invalid value : " + v));
    }
}

