/*
 * Decompiled with CFR 0.152.
 */
package com.power4j.fist.data.crud.validate;

import jakarta.validation.ConstraintViolation;
import jakarta.validation.ConstraintViolationException;
import jakarta.validation.MessageInterpolator;
import jakarta.validation.Validation;
import jakarta.validation.ValidationException;
import jakarta.validation.ValidatorFactory;
import java.util.Locale;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.hibernate.validator.messageinterpolation.ResourceBundleMessageInterpolator;
import org.hibernate.validator.spi.resourceloading.ResourceBundleLocator;
import org.springframework.context.MessageSource;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.context.support.ResourceBundleMessageSource;
import org.springframework.validation.beanvalidation.MessageSourceResourceBundleLocator;

public class ValidateUtil {
    private static ResourceBundleMessageSource getMessageSource() {
        ResourceBundleMessageSource bundleMessageSource = new ResourceBundleMessageSource();
        bundleMessageSource.setDefaultEncoding("UTF-8");
        bundleMessageSource.setBasenames(new String[]{"i18n/validation"});
        return bundleMessageSource;
    }

    public static <T> Set<ConstraintViolation<T>> check(ValidatorFactory factory, T object, Class<?> ... groups) {
        Locale.setDefault(LocaleContextHolder.getLocale());
        return factory.getValidator().validate(object, (Class[])groups);
    }

    public static <T> Set<ConstraintViolation<T>> check(T object, Class<?> ... groups) {
        try (ValidatorFactory factory = ValidateUtil.createValidatorFactory();){
            Set<ConstraintViolation<T>> set = ValidateUtil.check(factory, object, groups);
            return set;
        }
    }

    public static <T, E extends Exception> void validate(Function<Set<ConstraintViolation<T>>, E> exceptionTranslator, T object, Class<?> ... groups) throws E {
        Set<ConstraintViolation<T>> constraintViolations = ValidateUtil.check(object, groups);
        if (!constraintViolations.isEmpty()) {
            throw (Exception)exceptionTranslator.apply(constraintViolations);
        }
    }

    public static <T> void validate(T object, Class<?> ... groups) throws ConstraintViolationException {
        Set<ConstraintViolation<T>> constraintViolations = ValidateUtil.check(object, groups);
        if (!constraintViolations.isEmpty()) {
            throw new ConstraintViolationException(constraintViolations);
        }
    }

    public static <T> void validateAll(T object, Class<?> ... groups) throws ValidationException {
        ValidateUtil.validate(constraintViolations -> new ValidationException(constraintViolations.stream().map(ConstraintViolation::getMessage).collect(Collectors.joining(","))), object, groups);
    }

    public static ValidatorFactory createValidatorFactory() {
        return Validation.byDefaultProvider().configure().messageInterpolator((MessageInterpolator)new ResourceBundleMessageInterpolator((ResourceBundleLocator)new MessageSourceResourceBundleLocator((MessageSource)ValidateUtil.getMessageSource()))).buildValidatorFactory();
    }
}

