/*
 * Decompiled with CFR 0.152.
 */
package com.power4j.fist.data.domain;

import com.power4j.fist.data.domain.AbstractPageRequest;
import com.power4j.fist.data.domain.Pageable;
import com.power4j.fist.data.domain.Sort;

public class PageRequest
extends AbstractPageRequest {
    public static final int DEFAULT_PAGE_SIZE = 20;
    public static final int FIRST_PAGE = 1;
    private final Sort sort;

    PageRequest(int pageNumber, int pageSize, Sort sort) {
        super(pageNumber, pageSize);
        this.sort = sort;
    }

    public static PageRequest of(int pageNumber, int pageSize, Sort sort) {
        return new PageRequest(pageNumber, pageSize, sort);
    }

    public static PageRequest of(int pageNumber, int pageSize) {
        return PageRequest.of(pageNumber, pageSize, Sort.UNSORTED);
    }

    public static PageRequest of(int pageNumber) {
        return PageRequest.of(pageNumber, 20, Sort.UNSORTED);
    }

    public static PageRequest firstPage() {
        return PageRequest.of(1, 20, Sort.UNSORTED);
    }

    @Override
    public Pageable at(int pageNumber) {
        return new PageRequest(this.getPageNumber(), this.getPageSize(), this.getSort());
    }

    @Override
    public Sort getSort() {
        return this.sort;
    }

    @Override
    public PageRequest next() {
        return new PageRequest(this.getPageNumber() + 1, this.getPageSize(), this.getSort());
    }

    @Override
    public PageRequest first() {
        return new PageRequest(1, this.getPageSize(), this.getSort());
    }

    @Override
    public PageRequest previous() {
        return this.getPageNumber() == 1 ? this : new PageRequest(this.getPageNumber() - 1, this.getPageSize(), this.getSort());
    }
}

