/*
 * Decompiled with CFR 0.152.
 */
package com.power4j.fist.data.domain;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class Sort {
    public static final Direction DEFAULT_DIRECTION = Direction.ASC;
    public static final Sort UNSORTED = Sort.of(Collections.emptyList());
    private List<Order> orders = new ArrayList<Order>(2);

    public static Sort of(Collection<Order> orders) {
        return new Sort().orders(new ArrayList<Order>(orders));
    }

    public static Sort of(String ... props) {
        return Sort.of(DEFAULT_DIRECTION, props);
    }

    public static Sort of(Direction direction, String ... props) {
        List<Order> orders = Stream.of(props).map(prop -> new Order((String)prop, direction)).collect(Collectors.toList());
        return Sort.of(orders);
    }

    public Sort order(Order order) {
        this.orders.add(order);
        return this;
    }

    public Sort orders(List<Order> orders) {
        this.orders = orders;
        return this;
    }

    public List<Order> getOrders() {
        return this.orders;
    }

    public boolean isEmpty() {
        return this.orders.isEmpty();
    }

    public boolean isSorted() {
        return !this.isEmpty();
    }

    public boolean isUnsorted() {
        return !this.isSorted();
    }

    public static enum Direction {
        ASC,
        DESC;


        public boolean isAscending() {
            return this.equals((Object)ASC);
        }

        public boolean isDescending() {
            return this.equals((Object)DESC);
        }

        public static Direction fromString(String value) {
            try {
                return Direction.valueOf(value.toUpperCase(Locale.US));
            }
            catch (Exception e) {
                throw new IllegalArgumentException(String.format("Invalid value '%s' for orders given! Has to be either 'desc' or 'asc' (case insensitive).", value), e);
            }
        }

        public static Optional<Direction> fromOptionalString(String value) {
            try {
                return Optional.of(Direction.fromString(value));
            }
            catch (IllegalArgumentException e) {
                return Optional.empty();
            }
        }
    }

    public static class Order {
        private final String prop;
        private final Direction direction;

        public Order(String prop, Direction direction) {
            this.prop = prop;
            this.direction = direction;
        }

        public String getProp() {
            return this.prop;
        }

        public Direction getDirection() {
            return this.direction;
        }

        public boolean isAsc() {
            return Direction.ASC.equals((Object)this.direction);
        }
    }
}

