/*
 * Decompiled with CFR 0.152.
 */
package com.power4j.fist.data.excel;

import com.alibaba.excel.context.AnalysisContext;
import com.power4j.fist.data.excel.ExcelParser;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.convert.converter.Converter;

public class ExcelImporter<T, D> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ExcelImporter.class);
    private static final int DEFAULT_BATCH_SIZE = 1000;
    private final Class<T> docType;
    private final Converter<T, D> converter;
    private final Consumer<Collection<D>> entityHandler;
    private final int batchSize;

    public long doImport(InputStream stream) {
        int batch = this.batchSize > 0 ? this.batchSize : 1000;
        AtomicLong total = new AtomicLong();
        ArrayList list = new ArrayList(batch);
        BiConsumer<Object, AnalysisContext> handler = (data, context) -> {
            total.incrementAndGet();
            list.add(data);
            if (list.size() >= batch) {
                this.processAndClear(list);
            }
        };
        ExcelParser.builder().docType(this.docType).handler(handler).build().process(stream);
        this.processAndClear(list);
        return total.get();
    }

    protected void processAndClear(Collection<T> data) {
        if (data.isEmpty()) {
            return;
        }
        List entityList = data.stream().map(arg_0 -> this.converter.convert(arg_0)).collect(Collectors.toList());
        this.entityHandler.accept(entityList);
        data.clear();
    }

    @Generated
    ExcelImporter(Class<T> docType, Converter<T, D> converter, Consumer<Collection<D>> entityHandler, int batchSize) {
        this.docType = docType;
        this.converter = converter;
        this.entityHandler = entityHandler;
        this.batchSize = batchSize;
    }

    @Generated
    public static <T, D> ExcelImporterBuilder<T, D> builder() {
        return new ExcelImporterBuilder();
    }

    @Generated
    public static class ExcelImporterBuilder<T, D> {
        @Generated
        private Class<T> docType;
        @Generated
        private Converter<T, D> converter;
        @Generated
        private Consumer<Collection<D>> entityHandler;
        @Generated
        private int batchSize;

        @Generated
        ExcelImporterBuilder() {
        }

        @Generated
        public ExcelImporterBuilder<T, D> docType(Class<T> docType) {
            this.docType = docType;
            return this;
        }

        @Generated
        public ExcelImporterBuilder<T, D> converter(Converter<T, D> converter) {
            this.converter = converter;
            return this;
        }

        @Generated
        public ExcelImporterBuilder<T, D> entityHandler(Consumer<Collection<D>> entityHandler) {
            this.entityHandler = entityHandler;
            return this;
        }

        @Generated
        public ExcelImporterBuilder<T, D> batchSize(int batchSize) {
            this.batchSize = batchSize;
            return this;
        }

        @Generated
        public ExcelImporter<T, D> build() {
            return new ExcelImporter<T, D>(this.docType, this.converter, this.entityHandler, this.batchSize);
        }

        @Generated
        public String toString() {
            return "ExcelImporter.ExcelImporterBuilder(docType=" + this.docType + ", converter=" + this.converter + ", entityHandler=" + this.entityHandler + ", batchSize=" + this.batchSize + ")";
        }
    }
}

