/*
 * Decompiled with CFR 0.152.
 */
package com.power4j.fist.data.tenant.isolation;

import com.alibaba.ttl.TransmittableThreadLocal;
import com.power4j.fist.data.tenant.isolation.TenantHolder;
import java.util.ArrayDeque;
import java.util.Deque;
import lombok.Generated;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.function.Failable;
import org.apache.commons.lang3.function.FailableConsumer;
import org.apache.commons.lang3.function.FailableFunction;
import org.apache.commons.lang3.function.FailableRunnable;
import org.apache.commons.lang3.function.FailableSupplier;
import org.apache.commons.lang3.mutable.MutableObject;
import org.springframework.lang.Nullable;

public final class TenantBroker {
    private static final TransmittableThreadLocal<Deque<String>> DEBUG = new TransmittableThreadLocal<Deque<String>>(){

        protected Deque<String> initialValue() {
            return new ArrayDeque<String>();
        }
    };

    public static <T> T applyAs(@Nullable String tenant, FailableSupplier<T, ? extends Throwable> action, @Nullable FailableFunction<Throwable, T, ? extends Throwable> errorHandler) {
        MutableObject ret = new MutableObject();
        FailableRunnable runnable = () -> ret.setValue(action.get());
        FailableConsumer errorResume = errorHandler == null ? Failable::rethrow : ex -> ret.setValue(errorHandler.apply(ex));
        TenantBroker.runAs(tenant, (FailableRunnable<? extends Throwable>)runnable, (FailableConsumer<Throwable, ? extends Throwable>)errorResume);
        return (T)ret.getValue();
    }

    public static <T> T applyAs(@Nullable String tenant, FailableSupplier<T, ? extends Throwable> action) {
        return TenantBroker.applyAs(tenant, action, null);
    }

    public static void runAs(@Nullable String tenant, FailableRunnable<? extends Throwable> action, @Nullable FailableConsumer<Throwable, ? extends Throwable> errorHandler) {
        String pre = TenantHolder.getTenant().orElse(null);
        TenantHolder.setTenant(tenant);
        ((Deque)DEBUG.get()).push((String)ObjectUtils.defaultIfNull((Object)tenant, (Object)"null"));
        Failable.tryWithResources(action, errorHandler, (FailableRunnable[])new FailableRunnable[]{() -> {
            TenantHolder.setTenant(pre);
            ((Deque)DEBUG.get()).pop();
        }});
    }

    public static void runAs(@Nullable String tenant, FailableRunnable<? extends Throwable> action) {
        TenantBroker.runAs(tenant, action, null);
    }

    public static String dump() {
        return StringUtils.join((Iterable)((Iterable)DEBUG.get()), (String)" > ");
    }

    @Generated
    private TenantBroker() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

