/*
 * Decompiled with CFR 0.152.
 */
package com.power4j.fist.data.tree;

import com.power4j.fist.data.tree.TreeNodeUtil;
import com.power4j.fist.data.tree.TreeUtil;
import com.power4j.fist.data.tree.domain.Node;
import com.power4j.fist.data.tree.domain.NodeIdx;
import com.power4j.fist.data.tree.domain.TreeNode;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.apache.commons.lang3.ObjectUtils;

public class TreeMaker<ID, N extends Node<ID, N>> {
    private final Map<ID, N> data;

    TreeMaker(Map<ID, N> data) {
        this.data = data;
    }

    public static <ID, N extends Node<ID, N>> TreeMaker<ID, N> use(Collection<N> data) {
        Map sourceData = data.stream().collect(Collectors.toMap(Node::getId, Function.identity(), (x, y) -> y, LinkedHashMap::new));
        return new TreeMaker<ID, N>(sourceData);
    }

    public static <ID> TreeMaker<ID, TreeNode<ID>> useIdx(Collection<? extends NodeIdx<ID, ?>> nodes) {
        Function<Object, TreeNode> treeMapper = id -> TreeNode.of(id, null);
        Map<Object, Object> parentMap = nodes.stream().filter(o -> 1 == o.getDistance()).collect(Collectors.toMap(NodeIdx::getDescendant, NodeIdx::getAncestor));
        Map data = nodes.stream().filter(o -> 0 == o.getDistance()).map(NodeIdx::getAncestor).map(treeMapper).collect(Collectors.toMap(TreeNode::getId, Function.identity(), (x, y) -> y, LinkedHashMap::new));
        data.values().forEach(o -> o.setParentId(parentMap.get(o.getId())));
        return new TreeMaker(data);
    }

    public Optional<N> build(ID id) {
        List<Node> roots = this.build(o -> Objects.equals(o.getId(), id));
        return roots.stream().findFirst();
    }

    public List<N> build() {
        return this.makeTree(TreeMaker::findTopNodes);
    }

    public List<N> build(Predicate<N> rootPred) {
        Function<Map<ID, N>, Map<ID, N>> rootSelect = map -> map.entrySet().stream().filter(et -> rootPred.test((Node)et.getValue())).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue, (x, y) -> y, LinkedHashMap::new));
        return this.makeTree(rootSelect);
    }

    protected List<N> makeTree(Function<Map<ID, N>, Map<ID, N>> rootSelect) {
        if (ObjectUtils.isEmpty(this.data)) {
            return Collections.emptyList();
        }
        Map<ID, N> roots = rootSelect.apply(this.data);
        if (ObjectUtils.isEmpty(roots)) {
            return Collections.emptyList();
        }
        TreeNodeUtil.fetch(this.data, roots);
        return new ArrayList<N>(roots.values());
    }

    protected static <ID, N extends Node<ID, N>> Map<ID, N> findTopNodes(Map<ID, N> input) {
        return TreeUtil.findAncestors(input, Node::getId, Node::getParentId);
    }
}

