/*
 * Decompiled with CFR 0.152.
 */
package com.power4j.fist.boot.common.op.bus;

import com.power4j.fist.boot.common.op.bus.ErrorHandler;
import com.power4j.fist.boot.common.op.bus.OpEvent;
import com.power4j.fist.boot.common.op.bus.OpEventSource;
import com.power4j.fist.boot.common.op.bus.OpEventSubscriber;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.springframework.lang.Nullable;

public class Bus<T, E extends OpEvent<T>>
implements OpEventSource<T, E> {
    private List<OpEventSubscriber<T, E>> subscribers;
    @Nullable
    private ErrorHandler<E> errorHandler;

    public Bus() {
        this(new ArrayList<OpEventSubscriber<T, E>>(4), null);
    }

    public Bus(List<OpEventSubscriber<T, E>> subscribers, @Nullable ErrorHandler<E> errorHandler) {
        this.subscribers = Objects.requireNonNull(subscribers);
        this.errorHandler = errorHandler;
    }

    protected List<OpEventSubscriber<T, E>> getSubscribers() {
        return this.subscribers;
    }

    public void setSubscribers(List<OpEventSubscriber<T, E>> subscribers) {
        this.subscribers = subscribers;
    }

    public void setErrorHandler(@Nullable ErrorHandler<E> errorHandler) {
        this.errorHandler = errorHandler;
    }

    @Override
    public void fire(E event) {
        this.getSubscribers().forEach(observer -> this.doNotify((OpEventSubscriber<T, E>)observer, event));
    }

    protected void doNotify(OpEventSubscriber<T, E> observer, E event) {
        try {
            observer.subscribe(event);
        }
        catch (Exception e) {
            if (Objects.nonNull(this.errorHandler)) {
                this.errorHandler.onError(e, event);
            }
            throw e;
        }
    }
}

