/*
 * Decompiled with CFR 0.152.
 */
package com.power4j.fist.data.domain;

import com.power4j.coca.kit.common.lang.Obj;
import com.power4j.fist.data.domain.Pageable;
import com.power4j.fist.data.domain.Paged;
import com.power4j.fist.data.domain.Sort;
import java.util.Collections;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;

public class PageImpl<T>
implements Paged<T> {
    protected static final int FIRST_PAGE = 0;
    private final Pageable pageable;
    private final List<T> content;
    private final long total;

    public PageImpl(@Nullable List<T> content, Pageable pageable, long total) {
        this.pageable = pageable;
        this.total = total;
        this.content = (List)Obj.keepIfNotNull(content, Collections::emptyList);
    }

    @Override
    public int getPageNumber() {
        return this.pageable.getPageNumber();
    }

    @Override
    public int getPageSize() {
        return this.pageable.getPageSize();
    }

    @Override
    public int getNumberOfElements() {
        return this.content.size();
    }

    @Override
    public int getTotalPages() {
        return this.getPageSize() == 0 ? 1 : (int)Math.ceil((double)this.total / (double)this.getPageSize());
    }

    @Override
    public long getTotalElements() {
        return this.total;
    }

    @Override
    public List<T> getContent() {
        return Collections.unmodifiableList(this.content);
    }

    @Override
    public boolean hasContent() {
        return !this.content.isEmpty();
    }

    @Override
    public Sort getSort() {
        return this.pageable.getSort();
    }

    @Override
    public boolean isFirst() {
        return !this.hasPrevious();
    }

    @Override
    public boolean isLast() {
        return !this.hasNext();
    }

    @Override
    public boolean hasNext() {
        return this.getPageNumber() + 1 < this.getTotalPages();
    }

    @Override
    public boolean hasPrevious() {
        return this.getPageNumber() > 0;
    }

    @Override
    public Pageable nextPageable() {
        if (!this.hasNext()) {
            throw new IllegalArgumentException("No next page");
        }
        return this.pageable.next();
    }

    @Override
    public Pageable previousPageable() {
        if (!this.hasPrevious()) {
            throw new IllegalArgumentException("No previous page");
        }
        return this.pageable.previousOrFirst();
    }

    @Override
    public <U> Paged<U> map(Function<? super T, ? extends U> converter) {
        return new PageImpl<U>(this.getConvertedContent(converter), this.getPageable(), this.total);
    }

    protected <U> List<U> getConvertedContent(Function<? super T, ? extends U> converter) {
        Assert.notNull(converter, (String)"Function must not be null!");
        return this.content.stream().map(converter).collect(Collectors.toList());
    }
}

