/*
 * Decompiled with CFR 0.152.
 */
package com.power4j.fist.data.domain;

import com.power4j.fist.data.domain.PageRequest;
import com.power4j.fist.data.domain.Pageable;
import com.power4j.fist.data.domain.Sort;
import java.util.List;
import java.util.function.Function;

public interface Paged<T> {
    public int getPageNumber();

    public int getPageSize();

    public int getNumberOfElements();

    public int getTotalPages();

    public long getTotalElements();

    public List<T> getContent();

    public boolean hasContent();

    public Sort getSort();

    public boolean isFirst();

    public boolean isLast();

    public boolean hasNext();

    public boolean hasPrevious();

    default public Pageable getPageable() {
        return PageRequest.of(this.getPageNumber(), this.getPageSize(), this.getSort());
    }

    public Pageable nextPageable();

    default public Pageable nextOrLastPageable() {
        return this.hasNext() ? this.nextPageable() : this.getPageable();
    }

    public Pageable previousPageable();

    public <U> Paged<U> map(Function<? super T, ? extends U> var1);
}

