/*
 * Decompiled with CFR 0.152.
 */
package com.power4j.fist.data.excel;

import cn.idev.excel.EasyExcel;
import cn.idev.excel.context.AnalysisContext;
import cn.idev.excel.event.AnalysisEventListener;
import cn.idev.excel.read.listener.ReadListener;
import java.io.InputStream;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.BiConsumer;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExcelParser<T> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ExcelParser.class);
    private final Class<T> docType;
    private final BiConsumer<? super T, AnalysisContext> handler;

    public void process(InputStream stream) {
        final AtomicLong total = new AtomicLong();
        EasyExcel.read((InputStream)stream, this.docType, (ReadListener)new AnalysisEventListener<T>(){

            public void invoke(T data, AnalysisContext context) {
                ExcelParser.this.handler.accept(data, context);
            }

            public void doAfterAllAnalysed(AnalysisContext context) {
                if (log.isDebugEnabled()) {
                    log.debug("Analyse complete,total = {}", (Object)total.get());
                }
            }
        }).sheet().doRead();
    }

    @Generated
    ExcelParser(Class<T> docType, BiConsumer<? super T, AnalysisContext> handler) {
        this.docType = docType;
        this.handler = handler;
    }

    @Generated
    public static <T> ExcelParserBuilder<T> builder() {
        return new ExcelParserBuilder();
    }

    @Generated
    public Class<T> getDocType() {
        return this.docType;
    }

    @Generated
    public static class ExcelParserBuilder<T> {
        @Generated
        private Class<T> docType;
        @Generated
        private BiConsumer<? super T, AnalysisContext> handler;

        @Generated
        ExcelParserBuilder() {
        }

        @Generated
        public ExcelParserBuilder<T> docType(Class<T> docType) {
            this.docType = docType;
            return this;
        }

        @Generated
        public ExcelParserBuilder<T> handler(BiConsumer<? super T, AnalysisContext> handler) {
            this.handler = handler;
            return this;
        }

        @Generated
        public ExcelParser<T> build() {
            return new ExcelParser<T>(this.docType, this.handler);
        }

        @Generated
        public String toString() {
            return "ExcelParser.ExcelParserBuilder(docType=" + String.valueOf(this.docType) + ", handler=" + String.valueOf(this.handler) + ")";
        }
    }
}

