/*
 * Decompiled with CFR 0.152.
 */
package com.power4j.fist.data.migrate;

import cn.idev.excel.context.AnalysisContext;
import com.power4j.fist.data.excel.ExcelParser;
import com.power4j.fist.data.migrate.ImportDataHandler;
import com.power4j.fist.data.migrate.ImportStatistic;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.BiConsumer;
import lombok.Generated;

public final class MigrateUtil {
    private static final int DEFAULT_BATCH_SIZE = 1000;

    public static <T> ImportStatistic importExcel(InputStream stream, Class<T> docType, int batchSize, ImportDataHandler<T> consumer) {
        int batch = batchSize > 0 ? batchSize : 1000;
        AtomicLong total = new AtomicLong();
        ArrayList list = new ArrayList(batch);
        BiConsumer<Object, AnalysisContext> handler = (data, context) -> {
            total.incrementAndGet();
            list.add(data);
            if (list.size() >= batch) {
                MigrateUtil.processAndClear(list, consumer);
            }
        };
        consumer.beforeAll();
        ExcelParser.builder().docType(docType).handler(handler).build().process(stream);
        MigrateUtil.processAndClear(list, consumer);
        consumer.afterAll();
        return consumer.statistic();
    }

    static <T> void processAndClear(Collection<T> data, ImportDataHandler<T> consumer) {
        if (data.isEmpty()) {
            return;
        }
        consumer.accept(new ArrayList<T>(data));
        data.clear();
    }

    @Generated
    private MigrateUtil() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

