/*
 * Decompiled with CFR 0.152.
 */
package com.power4j.fist.data.tree;

import com.power4j.fist.data.tree.domain.Node;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import lombok.Generated;
import org.apache.commons.lang3.ObjectUtils;

public final class TreeNodeUtil {
    public static <ID, N extends Node<ID, N>> void treeWalk(Collection<? extends N> roots, Consumer<? super N> consumer) {
        for (Node node : roots) {
            consumer.accept(node);
            List children = node.getChildren();
            if (!ObjectUtils.isNotEmpty(children)) continue;
            TreeNodeUtil.treeWalk(children, consumer);
        }
    }

    public static <ID, N extends Node<ID, N>, U extends Comparable<? super U>> void sortNodes(List<N> list, Function<? super N, ? extends U> keyExtractor) {
        list.sort(Comparator.comparing(keyExtractor));
        for (Node node : list) {
            List children = node.getChildren();
            if (!ObjectUtils.isNotEmpty(children)) continue;
            TreeNodeUtil.sortNodes(children, keyExtractor);
        }
    }

    public static <ID, N extends Node<ID, N>> List<N> flatten(List<N> roots) {
        ArrayList list = new ArrayList(roots.size());
        TreeNodeUtil.treeWalk(roots, list::add);
        return list;
    }

    public static <ID, N extends Node<ID, N>> void fetch(Map<ID, N> source, Map<ID, N> roots) {
        if (roots.isEmpty()) {
            return;
        }
        for (Node node : source.values()) {
            Object parentId;
            Node parentNode;
            Object id;
            if (null == node || roots.containsKey(id = Objects.requireNonNull(node.getId())) || null == (parentNode = Optional.ofNullable((Node)roots.get(parentId = node.getParentId())).orElseGet(() -> (Node)source.get(parentId)))) continue;
            parentNode.appendChild(node);
        }
    }

    public static <ID, N extends Node<ID, N>, U> void convert(Collection<? extends N> src, ConvertOp<N, U> op, Collection<? super U> dist) {
        for (Node node : src) {
            Object target = op.objectConvert.apply(node);
            dist.add(target);
            List children = node.getChildren();
            if (!ObjectUtils.isNotEmpty(children)) continue;
            ArrayList list = new ArrayList(2);
            TreeNodeUtil.convert(children, op, list);
            op.childSetter.accept(target, list);
        }
    }

    public static <ID, N extends Node<ID, N>, U> List<U> convertToList(Collection<? extends N> src, ConvertOp<N, U> op) {
        ArrayList list = new ArrayList(2);
        TreeNodeUtil.convert(src, op, list);
        return list;
    }

    @Generated
    private TreeNodeUtil() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }

    public static class ConvertOp<S, T> {
        private final Function<? super S, ? extends T> objectConvert;
        private final BiConsumer<? super T, Collection<T>> childSetter;

        @Generated
        ConvertOp(Function<? super S, ? extends T> objectConvert, BiConsumer<? super T, Collection<T>> childSetter) {
            this.objectConvert = objectConvert;
            this.childSetter = childSetter;
        }

        @Generated
        public static <S, T> ConvertOpBuilder<S, T> builder() {
            return new ConvertOpBuilder();
        }

        @Generated
        public Function<? super S, ? extends T> getObjectConvert() {
            return this.objectConvert;
        }

        @Generated
        public BiConsumer<? super T, Collection<T>> getChildSetter() {
            return this.childSetter;
        }

        @Generated
        public static class ConvertOpBuilder<S, T> {
            @Generated
            private Function<? super S, ? extends T> objectConvert;
            @Generated
            private BiConsumer<? super T, Collection<T>> childSetter;

            @Generated
            ConvertOpBuilder() {
            }

            @Generated
            public ConvertOpBuilder<S, T> objectConvert(Function<? super S, ? extends T> objectConvert) {
                this.objectConvert = objectConvert;
                return this;
            }

            @Generated
            public ConvertOpBuilder<S, T> childSetter(BiConsumer<? super T, Collection<T>> childSetter) {
                this.childSetter = childSetter;
                return this;
            }

            @Generated
            public ConvertOp<S, T> build() {
                return new ConvertOp<S, T>(this.objectConvert, this.childSetter);
            }

            @Generated
            public String toString() {
                return "TreeNodeUtil.ConvertOp.ConvertOpBuilder(objectConvert=" + String.valueOf(this.objectConvert) + ", childSetter=" + String.valueOf(this.childSetter) + ")";
            }
        }
    }
}

