/*
 * Decompiled with CFR 0.152.
 */
package com.power4j.fist.data.tree.domain;

import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;
import org.springframework.lang.Nullable;

public interface Node<ID, C extends Node<ID, C>> {
    @Nullable
    public ID getParentId();

    public ID getId();

    public void appendChild(C var1);

    default public void appendChildren(Collection<? extends C> list) {
        list.forEach(this::appendChild);
    }

    @Nullable
    public List<C> getChildren();

    @Nullable
    default public C childAt(int index) {
        List<C> list = this.getChildren();
        if (Objects.isNull(list) || list.isEmpty()) {
            return null;
        }
        return (C)(index >= 0 && index < list.size() ? (Node)list.get(index) : null);
    }

    default public Optional<C> findFirstChild(Predicate<? super C> predicate) {
        List<C> list = this.getChildren();
        if (Objects.isNull(list) || list.isEmpty()) {
            return Optional.empty();
        }
        return list.stream().filter(predicate).findFirst();
    }

    default public boolean hasParent() {
        return Objects.nonNull(this.getParentId());
    }

    default public boolean hasChildren() {
        return Objects.nonNull(this.getChildren()) && !this.getChildren().isEmpty();
    }
}

