/*
 * Decompiled with CFR 0.152.
 */
package com.power4j.fist.boot.security.context;

import com.alibaba.ttl.TransmittableThreadLocal;
import com.power4j.fist.boot.security.core.UserInfo;
import java.util.Optional;
import lombok.Generated;
import org.springframework.lang.Nullable;

public final class UserContextHolder {
    private static final TransmittableThreadLocal<Ctx> CTX = new TransmittableThreadLocal<Ctx>(){

        protected Ctx initialValue() {
            return new Ctx();
        }
    };

    private UserContextHolder() {
    }

    public static Optional<UserInfo> getUser() {
        return Optional.ofNullable(((Ctx)UserContextHolder.CTX.get()).info);
    }

    public static UserInfo requireUser() {
        return UserContextHolder.getUser().orElseThrow(() -> new IllegalStateException("Can not offer " + UserInfo.class.getSimpleName()));
    }

    public static void setUser(@Nullable UserInfo val) {
        ((Ctx)CTX.get()).setInfo(val);
    }

    public static void setOriginalValue(String val) {
        ((Ctx)CTX.get()).setOriginalValue(val);
    }

    public static Optional<String> getOriginalValue() {
        return Optional.ofNullable(((Ctx)CTX.get()).getOriginalValue());
    }

    static class Ctx {
        @Nullable
        private UserInfo info;
        @Nullable
        private String originalValue;

        @Generated
        public Ctx() {
        }

        @Nullable
        @Generated
        public UserInfo getInfo() {
            return this.info;
        }

        @Nullable
        @Generated
        public String getOriginalValue() {
            return this.originalValue;
        }

        @Generated
        public void setInfo(@Nullable UserInfo info) {
            this.info = info;
        }

        @Generated
        public void setOriginalValue(@Nullable String originalValue) {
            this.originalValue = originalValue;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Ctx)) {
                return false;
            }
            Ctx other = (Ctx)o;
            if (!other.canEqual(this)) {
                return false;
            }
            UserInfo this$info = this.getInfo();
            UserInfo other$info = other.getInfo();
            if (this$info == null ? other$info != null : !this$info.equals(other$info)) {
                return false;
            }
            String this$originalValue = this.getOriginalValue();
            String other$originalValue = other.getOriginalValue();
            return !(this$originalValue == null ? other$originalValue != null : !this$originalValue.equals(other$originalValue));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof Ctx;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            UserInfo $info = this.getInfo();
            result = result * 59 + ($info == null ? 43 : $info.hashCode());
            String $originalValue = this.getOriginalValue();
            result = result * 59 + ($originalValue == null ? 43 : $originalValue.hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "UserContextHolder.Ctx(info=" + this.getInfo() + ", originalValue=" + this.getOriginalValue() + ")";
        }
    }
}

