/*
 * Decompiled with CFR 0.152.
 */
package com.power4j.fist.boot.security.core;

import com.power4j.fist.boot.common.utils.MapKit;
import com.power4j.fist.boot.security.core.UserInfo;
import com.power4j.fist.boot.security.core.UserInfoExtractor;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.reflect.TypeLiteral;
import org.apache.commons.lang3.reflect.Typed;
import org.springframework.lang.Nullable;

public class DefaultUserInfoExtractor
implements UserInfoExtractor {
    private static final Typed<Collection<Object>> OBJ_COLLECTION = new TypeLiteral<Collection<Object>>(){};
    private static final char CHAR_COMMA = ',';

    public Optional<UserInfo> extractAuthUser(@Nullable Map<String, ?> userInfoMap) {
        return Optional.ofNullable(this.extractFromMap(userInfoMap));
    }

    private List<String> getAuthorities(Map<String, ?> map) {
        Object authorities = map.get("authorities");
        if (authorities instanceof String) {
            return Arrays.asList(StringUtils.split((String)((String)authorities), (char)','));
        }
        if (authorities instanceof Collection) {
            return ((Collection)authorities).stream().map(Object::toString).collect(Collectors.toList());
        }
        return Collections.emptyList();
    }

    @Nullable
    protected UserInfo extractFromMap(@Nullable Map<String, ?> userInfoMap) {
        if (Objects.isNull(userInfoMap)) {
            return null;
        }
        String nickName = MapUtils.getString(userInfoMap, (Object)"nickName");
        String avatarUrl = MapUtils.getString(userInfoMap, (Object)"avatarUrl");
        String username = MapUtils.getString(userInfoMap, (Object)"username");
        Long userId = MapUtils.getLong(userInfoMap, (Object)"userId");
        String userSource = MapUtils.getString(userInfoMap, (Object)"userSource");
        String dept = MapUtils.getString(userInfoMap, (Object)"dept");
        List roleList = MapKit.readAsList(userInfoMap, (Object)"roles", Objects::toString);
        List permissions = MapKit.readAsList(userInfoMap, (Object)"permissions", Objects::toString);
        UserInfo info = new UserInfo();
        info.setUsername(username);
        info.setUserId(userId);
        info.setNickName(nickName);
        info.setAvatarUrl(avatarUrl);
        info.putMetaProp("roles", (Object)roleList);
        info.putMetaProp("permissions", (Object)permissions);
        info.putMetaProp("userSource", (Object)userSource);
        info.putMetaProp("dept", (Object)dept);
        return info;
    }
}

