/*
 * Decompiled with CFR 0.152.
 */
package com.power4j.fist.boot.security.inner;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.power4j.coca.kit.common.io.codec.CodecException;
import com.power4j.coca.kit.common.io.codec.impl.BufferGz;
import com.power4j.coca.kit.common.text.obscure.StrObscurer;
import com.power4j.fist.boot.security.core.UserInfo;
import com.power4j.fist.boot.security.inner.UserCodec;
import com.power4j.fist.boot.security.inner.UserCodecException;
import java.util.Collections;
import java.util.function.Predicate;
import java.util.stream.Collectors;

public class DefaultUserCodec
implements UserCodec {
    private Predicate<String> zipPredicate = str -> str.length() > 512;
    private final StrObscurer obscurer;
    private ObjectMapper objectMapper = new ObjectMapper().configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);

    public DefaultUserCodec() {
        this.obscurer = StrObscurer.ofEncoders(Collections.singletonList(new BufferGz()));
    }

    public DefaultUserCodec setObjectMapper(ObjectMapper objectMapper) {
        this.objectMapper = objectMapper;
        return this;
    }

    public DefaultUserCodec setZipPredicate(Predicate<String> zipPredicate) {
        this.zipPredicate = zipPredicate;
        return this;
    }

    @Override
    public String encode(UserInfo user) {
        try {
            String json = this.objectMapper.writeValueAsString((Object)user);
            StrObscurer.EncoderSelector selector = (s, l) -> l.stream().filter(enc -> this.zipPredicate.test(s)).collect(Collectors.toList());
            return this.obscurer.obscure(json, selector);
        }
        catch (JsonProcessingException | CodecException e) {
            throw new UserCodecException(e.getMessage(), e);
        }
    }

    @Override
    public UserInfo decode(String value) {
        try {
            String json = this.obscurer.parse(value);
            return (UserInfo)this.objectMapper.readValue(json, UserInfo.class);
        }
        catch (JsonProcessingException | CodecException e) {
            throw new UserCodecException(e.getMessage(), e);
        }
    }
}

