/*
 * Decompiled with CFR 0.152.
 */
package com.power4j.fist.boot.security.inner;

import com.power4j.coca.kit.common.exception.WrappedException;
import com.power4j.fist.boot.common.error.CommonErrors;
import com.power4j.fist.boot.security.context.UserContextHolder;
import com.power4j.fist.boot.security.core.UserInfo;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import lombok.Generated;
import org.apache.commons.lang3.function.FailableRunnable;
import org.apache.commons.lang3.reflect.TypeLiteral;
import org.apache.commons.lang3.reflect.Typed;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.lang.Nullable;

public final class SecurityUtil {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(SecurityUtil.class);

    public static Optional<UserInfo> getUser() {
        return UserContextHolder.getUser();
    }

    public static UserInfo requireUser() {
        return SecurityUtil.getUser().orElseThrow(CommonErrors::authRequiredError);
    }

    public static Optional<String> getTenantId() {
        return SecurityUtil.getUser().flatMap(u -> u.getMetaProp("tenantId", String.class));
    }

    public static String requireTenantId() {
        return SecurityUtil.getTenantId().orElseThrow(CommonErrors::authRequiredError);
    }

    public static Optional<String> getUsername() {
        return SecurityUtil.getUser().map(UserInfo::getUsername);
    }

    public static String requireUsername() {
        return SecurityUtil.getUsername().orElseThrow(CommonErrors::authRequiredError);
    }

    public static Optional<Long> getUserId() {
        return SecurityUtil.getUser().map(UserInfo::getUserId);
    }

    public static long requireUserId() {
        return SecurityUtil.getUserId().orElseThrow(CommonErrors::authRequiredError);
    }

    public static Set<String> getRoles() {
        TypeLiteral<List<String>> type = new TypeLiteral<List<String>>(){};
        return SecurityUtil.getUser().flatMap(arg_0 -> SecurityUtil.lambda$getRoles$1((Typed)type, arg_0)).map(HashSet::new).orElse(new HashSet());
    }

    public static void act(@Nullable UserInfo user, FailableRunnable<Exception> runnable) throws WrappedException {
        UserInfo pre = SecurityUtil.getUser().orElse(null);
        try {
            UserContextHolder.setUser(user);
            log.trace("Run as user: {}", (Object)(user == null ? "null" : user.getUsername()));
            runnable.run();
        }
        catch (Exception e) {
            throw WrappedException.wrap((Throwable)e);
        }
        finally {
            UserContextHolder.setUser(pre);
        }
    }

    @Generated
    private SecurityUtil() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }

    private static /* synthetic */ Optional lambda$getRoles$1(Typed type, UserInfo u) {
        return u.getMetaProp("roles", type);
    }
}

