/*
 * Decompiled with CFR 0.152.
 */
package com.power4j.fist.boot.security.inner;

import com.power4j.coca.kit.common.exception.WrappedException;
import com.power4j.fist.boot.common.utils.NetKit;
import com.power4j.fist.boot.security.context.UserContextHolder;
import com.power4j.fist.boot.security.core.UserInfo;
import com.power4j.fist.boot.security.inner.SecurityUtil;
import com.power4j.fist.boot.security.inner.UserCodecException;
import com.power4j.fist.boot.security.inner.UserDecoder;
import inet.ipaddr.AddressStringException;
import inet.ipaddr.IPAddress;
import inet.ipaddr.IPAddressString;
import jakarta.servlet.FilterChain;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.Collection;
import lombok.Generated;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.function.FailableRunnable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.filter.OncePerRequestFilter;

public class TrustedUserFilter
extends OncePerRequestFilter {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(TrustedUserFilter.class);
    private static final String USER_ATTR_KEY = "fiamc.trusted-user-info-value";
    private final UserDecoder userDecoder;
    private boolean strictMode = true;
    private final Collection<IPAddress> whitelist = new ArrayList<IPAddress>(4);

    public void setWhitelist(Collection<String> list) {
        this.whitelist.clear();
        if (ObjectUtils.isNotEmpty(list)) {
            for (String p : list) {
                try {
                    IPAddressString ip = new IPAddressString(p);
                    ip.validate();
                    this.whitelist.add(ip.getAddress());
                }
                catch (AddressStringException e) {
                    String msg = "\u975e\u6cd5IP\u5730\u5740:" + p;
                    throw new IllegalArgumentException(msg, e);
                }
            }
        }
    }

    protected void doFilterInternal(HttpServletRequest request, HttpServletResponse response, FilterChain filterChain) throws ServletException, IOException {
        block6: {
            String userValue = request.getHeader("X-USER-IN");
            UserContextHolder.setOriginalValue(userValue);
            request.setAttribute(USER_ATTR_KEY, (Object)userValue);
            UserInfo info = null;
            if (StringUtils.isNotEmpty((CharSequence)userValue) && this.isTrusted(request)) {
                try {
                    info = this.userDecoder.decode(userValue);
                }
                catch (UserCodecException e) {
                    log.warn(e.getMessage(), (Throwable)e);
                }
            }
            try {
                SecurityUtil.act(info, (FailableRunnable<Exception>)((FailableRunnable)() -> filterChain.doFilter((ServletRequest)request, (ServletResponse)response)));
            }
            catch (WrappedException e) {
                if (e.getCause() instanceof ServletException) {
                    throw (ServletException)e.getOriginal(ServletException.class);
                }
                if (!(e.getCause() instanceof IOException)) break block6;
                throw (IOException)e.getOriginal(IOException.class);
            }
        }
    }

    private boolean isTrusted(HttpServletRequest request) {
        if (this.strictMode) {
            String ip = request.getRemoteAddr();
            if (ObjectUtils.isNotEmpty(this.whitelist)) {
                IPAddress reqAddr = new IPAddressString(ip).getAddress();
                return this.whitelist.stream().anyMatch(addr -> addr.contains(reqAddr));
            }
            InetAddress address = NetKit.parse((String)ip);
            if (address.isLoopbackAddress() || address.isSiteLocalAddress()) {
                return true;
            }
            log.warn("\u8ba4\u8bc1\u4fe1\u606f\u4e0d\u53ef\u4fe1,\u6765\u6e90:{}", (Object)ip);
            return false;
        }
        return true;
    }

    @Generated
    public TrustedUserFilter(UserDecoder userDecoder) {
        this.userDecoder = userDecoder;
    }

    @Generated
    public void setStrictMode(boolean strictMode) {
        this.strictMode = strictMode;
    }
}

