/*
 * Decompiled with CFR 0.152.
 */
package com.power4j.fist.boot.security.oauth2;

import com.power4j.fist.boot.security.oauth2.ServerBearerTokenResolver;
import com.power4j.fist.support.spring.web.reactive.util.ServerHttpRequestUtil;
import java.util.Collection;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.server.reactive.ServerHttpRequest;
import org.springframework.lang.Nullable;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

public class DefaultServerBearerTokenResolver
implements ServerBearerTokenResolver {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DefaultServerBearerTokenResolver.class);
    private static final Pattern authorizationPattern = Pattern.compile("^Bearer (?<token>[a-zA-Z0-9-._~+/]+=*)$", 2);
    private boolean allowUriQueryParameter = false;
    private String bearerTokenHeaderName = "Authorization";

    @Override
    @Nullable
    public String resolve(ServerHttpRequest request) {
        String authorizationHeaderToken = this.resolveFromAuthorizationHeader(request.getHeaders());
        String parameterToken = DefaultServerBearerTokenResolver.resolveAccessTokenFromRequest(request);
        if (authorizationHeaderToken != null) {
            if (parameterToken != null) {
                log.warn("Found multiple bearer tokens in the request:{}", (Object)ServerHttpRequestUtil.simpleRequestLine((ServerHttpRequest)request));
            }
            return authorizationHeaderToken;
        }
        if (parameterToken != null && this.isParameterTokenSupportedForRequest(request)) {
            return parameterToken;
        }
        return null;
    }

    @Nullable
    private static String resolveAccessTokenFromRequest(ServerHttpRequest request) {
        List parameterTokens = (List)request.getQueryParams().get((Object)"access_token");
        if (CollectionUtils.isEmpty((Collection)parameterTokens)) {
            return null;
        }
        if (parameterTokens.size() > 1) {
            log.warn("Found multiple bearer tokens in the request:{}", (Object)ServerHttpRequestUtil.simpleRequestLine((ServerHttpRequest)request));
        }
        return (String)parameterTokens.get(0);
    }

    public void setAllowUriQueryParameter(boolean allowUriQueryParameter) {
        this.allowUriQueryParameter = allowUriQueryParameter;
    }

    public void setBearerTokenHeaderName(String bearerTokenHeaderName) {
        this.bearerTokenHeaderName = bearerTokenHeaderName;
    }

    @Nullable
    private String resolveFromAuthorizationHeader(HttpHeaders headers) {
        String authorization = headers.getFirst(this.bearerTokenHeaderName);
        if (!StringUtils.startsWithIgnoreCase((String)authorization, (String)"bearer")) {
            return null;
        }
        Matcher matcher = authorizationPattern.matcher(authorization);
        if (!matcher.matches()) {
            log.warn("Bearer token  is malformed:{}", (Object)authorization);
            return null;
        }
        return matcher.group("token");
    }

    private boolean isParameterTokenSupportedForRequest(ServerHttpRequest request) {
        return this.allowUriQueryParameter && HttpMethod.GET.equals((Object)request.getMethod());
    }
}

