/*
 * Decompiled with CFR 0.152.
 */
package com.power4j.fist.boot.security.oauth2;

import java.util.Arrays;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.springframework.lang.Nullable;

public enum Oauth2GrantType {
    AUTHORIZATION_CODE("authorization_code"),
    IMPLICIT("implicit"),
    REFRESH_TOKEN("refresh_token"),
    CLIENT_CREDENTIALS("client_credentials"),
    PASSWORD("password");

    private final String value;

    private Oauth2GrantType(String value) {
        this.value = value;
    }

    public String getValue() {
        return this.value;
    }

    public static Set<String> valueSet() {
        return Arrays.stream(Oauth2GrantType.values()).map(Oauth2GrantType::getValue).collect(Collectors.toSet());
    }

    @Nullable
    public static Oauth2GrantType parseOrDefault(@Nullable String value, @Nullable Oauth2GrantType defValue) {
        if (value == null) {
            return defValue;
        }
        for (Oauth2GrantType o : Oauth2GrantType.values()) {
            if (!o.getValue().equals(value)) continue;
            return o;
        }
        return defValue;
    }

    @Nullable
    public static Oauth2GrantType parseOrNull(String value) {
        return Oauth2GrantType.parseOrDefault(value, null);
    }

    public static Oauth2GrantType parseOrThrow(String value, Function<String, RuntimeException> thrower) {
        Oauth2GrantType o = Oauth2GrantType.parseOrDefault(value, null);
        if (o == null) {
            throw thrower.apply(value);
        }
        return o;
    }

    public static Oauth2GrantType parse(String value) throws IllegalArgumentException {
        return Oauth2GrantType.parseOrThrow(value, v -> new IllegalArgumentException("Invalid value : " + v));
    }
}

