/*
 * Decompiled with CFR 0.152.
 */
package com.power4j.fist.boot.security.oauth2;

import com.power4j.fist.boot.security.core.DefaultUserInfoExtractor;
import com.power4j.fist.boot.security.core.UserInfo;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import lombok.Generated;
import org.apache.commons.collections4.MapUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.lang.Nullable;

public class Oauth2UserInfoExtractor
extends DefaultUserInfoExtractor {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(Oauth2UserInfoExtractor.class);
    protected static final String KEY_CLIENT_ID = "client_id";

    @Override
    public Optional<UserInfo> extractAuthUser(@Nullable Map<String, ?> map) {
        if (Objects.isNull(map)) {
            return Optional.empty();
        }
        String clientId = MapUtils.getString(map, (Object)KEY_CLIENT_ID);
        Map userInfoMap = Optional.of(map).map(o -> o.get("userInfo")).orElse(null);
        if (Objects.isNull(userInfoMap)) {
            log.debug("client authentication :{}", (Object)clientId);
            return Optional.empty();
        }
        UserInfo info = this.extractFromMap(userInfoMap);
        if (Objects.nonNull(info)) {
            info.putMetaProp("clientId", (Object)clientId);
        }
        return Optional.ofNullable(info);
    }
}

