/*
 * Decompiled with CFR 0.152.
 */
package com.power4j.fist.boot.security.oauth2.server.resource.introspection;

import com.power4j.fist.boot.security.oauth2.DefaultOauth2AuthenticatedPrincipal;
import com.power4j.fist.boot.security.oauth2.Oauth2AuthenticatedPrincipal;
import com.power4j.fist.boot.security.oauth2.server.resource.introspection.BadOpaqueTokenException;
import com.power4j.fist.boot.security.oauth2.server.resource.introspection.Oauth2IntrospectionException;
import com.power4j.fist.boot.security.oauth2.server.resource.introspection.ReactiveOpaqueTokenIntrospector;
import com.power4j.fist.security.core.authorization.domain.GrantedPermission;
import com.power4j.fist.security.core.authorization.domain.SimplePermission;
import java.net.URI;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.core.io.buffer.DataBuffer;
import org.springframework.core.io.buffer.DataBufferUtils;
import org.springframework.http.HttpStatus;
import org.springframework.util.Assert;
import org.springframework.web.reactive.function.BodyInserter;
import org.springframework.web.reactive.function.BodyInserters;
import org.springframework.web.reactive.function.client.ClientResponse;
import org.springframework.web.reactive.function.client.WebClient;
import reactor.core.publisher.Mono;

public class DefaultReactiveOpaqueTokenIntrospector
implements ReactiveOpaqueTokenIntrospector {
    private static final String AUTHORITY_PREFIX = "SCOPE_";
    private static final ParameterizedTypeReference<Map<String, Object>> STRING_OBJECT_MAP = new ParameterizedTypeReference<Map<String, Object>>(){};
    private final URI introspectionUri;
    private final WebClient webClient;

    public DefaultReactiveOpaqueTokenIntrospector(String introspectionUri, String clientId, String clientSecret) {
        Assert.hasText((String)introspectionUri, (String)"introspectionUri cannot be empty");
        Assert.hasText((String)clientId, (String)"clientId cannot be empty");
        Assert.notNull((Object)clientSecret, (String)"clientSecret cannot be null");
        this.introspectionUri = URI.create(introspectionUri);
        this.webClient = WebClient.builder().defaultHeaders(h -> h.setBasicAuth(clientId, clientSecret)).build();
    }

    public DefaultReactiveOpaqueTokenIntrospector(String introspectionUri, WebClient webClient) {
        Assert.hasText((String)introspectionUri, (String)"introspectionUri cannot be null");
        Assert.notNull((Object)webClient, (String)"webClient cannot be null");
        this.introspectionUri = URI.create(introspectionUri);
        this.webClient = webClient;
    }

    @Override
    public Mono<Oauth2AuthenticatedPrincipal> introspect(String token) {
        return Mono.just((Object)token).flatMap(this::makeRequest).flatMap(this::adaptToNimbusResponse).map(this::convertClaimsSet).onErrorMap(e -> !(e instanceof Oauth2IntrospectionException), this::onError);
    }

    private Mono<ClientResponse> makeRequest(String token) {
        return ((WebClient.RequestBodySpec)((WebClient.RequestBodySpec)this.webClient.post().uri(this.introspectionUri)).header("Accept", new String[]{"application/json"})).body((BodyInserter)BodyInserters.fromFormData((String)"token", (String)token)).exchange();
    }

    private Mono<Map<String, Object>> adaptToNimbusResponse(ClientResponse responseEntity) {
        if (responseEntity.statusCode() != HttpStatus.OK) {
            return responseEntity.bodyToFlux(DataBuffer.class).map(DataBufferUtils::release).then(Mono.error((Throwable)new Oauth2IntrospectionException("Introspection endpoint responded with " + responseEntity.statusCode())));
        }
        return responseEntity.bodyToMono(STRING_OBJECT_MAP).filter(body -> (Boolean)body.compute("active", (k, v) -> {
            if (v instanceof String) {
                return Boolean.parseBoolean((String)v);
            }
            if (v instanceof Boolean) {
                return v;
            }
            return false;
        })).switchIfEmpty(Mono.error(() -> new BadOpaqueTokenException("Provided token isn't active")));
    }

    private Oauth2AuthenticatedPrincipal convertClaimsSet(Map<String, Object> claims) {
        claims.computeIfPresent("aud", (k, v) -> {
            if (v instanceof String) {
                return Collections.singletonList(v);
            }
            return v;
        });
        claims.computeIfPresent("client_id", (k, v) -> v.toString());
        claims.computeIfPresent("exp", (k, v) -> Instant.ofEpochSecond(((Number)v).longValue()));
        claims.computeIfPresent("iat", (k, v) -> Instant.ofEpochSecond(((Number)v).longValue()));
        claims.computeIfPresent("iss", (k, v) -> v.toString());
        claims.computeIfPresent("nbf", (k, v) -> Instant.ofEpochSecond(((Number)v).longValue()));
        ArrayList<GrantedPermission> authorities = new ArrayList<GrantedPermission>();
        claims.computeIfPresent("scope", (k, v) -> {
            if (v instanceof String) {
                List<String> scopes = Arrays.asList(((String)v).split(" "));
                for (String scope : scopes) {
                    authorities.add(new SimplePermission(AUTHORITY_PREFIX + scope));
                }
                return scopes;
            }
            return v;
        });
        return new DefaultOauth2AuthenticatedPrincipal(claims, authorities);
    }

    private BadOpaqueTokenException onError(Throwable ex) {
        return new BadOpaqueTokenException(ex.getMessage(), ex);
    }
}

