/*
 * Decompiled with CFR 0.152.
 */
package com.power4j.fist.security.core.authorization.domain;

import com.power4j.fist.security.core.authorization.domain.AuthenticatedUser;
import com.power4j.fist.security.core.authorization.domain.GrantedPermission;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.springframework.lang.Nullable;

public class AnonymousUser
implements AuthenticatedUser {
    private static final String USER_NAME = "AnonymousUser";
    private static final String TENANT = "Anonymous";
    private final Map<String, GrantedPermission> permissionMap;
    private final Map<String, Object> additionalInfo = new HashMap<String, Object>();
    @Nullable
    private String id;

    public AnonymousUser(Map<String, GrantedPermission> permissionMap) {
        this.permissionMap = Collections.unmodifiableMap(permissionMap);
    }

    public AnonymousUser() {
        this(Collections.emptyMap());
    }

    @Override
    public String getUsername() {
        return USER_NAME;
    }

    @Override
    public String getTenantId() {
        return TENANT;
    }

    @Override
    public Map<String, GrantedPermission> getPermissions() {
        return this.permissionMap;
    }

    @Override
    public Map<String, Object> getAdditionalInfo() {
        return this.additionalInfo;
    }

    @Nullable
    public String getId() {
        return this.id;
    }

    public void setId(@Nullable String id) {
        this.id = id;
    }

    @Override
    public boolean isAnonymous() {
        return true;
    }
}

