/*
 * Decompiled with CFR 0.152.
 */
package com.power4j.fist.security.core.authorization.filter.reactive;

import com.power4j.fist.security.core.authorization.filter.reactive.ServerAuthFilter;
import com.power4j.fist.security.core.authorization.filter.reactive.ServerAuthFilterChain;
import java.util.Collections;
import java.util.List;
import java.util.ListIterator;
import org.springframework.lang.Nullable;
import reactor.core.publisher.Mono;

public class DefaultServerAuthFilterChain<C, F extends ServerAuthFilter<C>>
implements ServerAuthFilterChain<C> {
    private static final String CHECK_POINT_TAG = String.format(" [%s]", DefaultServerAuthFilterChain.class.getName());
    private final List<F> filters;
    @Nullable
    protected final ServerAuthFilter<C> currentFilter;
    @Nullable
    protected final DefaultServerAuthFilterChain<C, F> chain;

    public DefaultServerAuthFilterChain(List<F> filters) {
        this.filters = Collections.unmodifiableList(filters);
        DefaultServerAuthFilterChain<C, F> chain = DefaultServerAuthFilterChain.initChain(filters);
        this.currentFilter = chain.currentFilter;
        this.chain = chain.chain;
    }

    private static <C, F extends ServerAuthFilter<C>> DefaultServerAuthFilterChain<C, F> initChain(List<F> filters) {
        DefaultServerAuthFilterChain<C, F> chain = new DefaultServerAuthFilterChain<C, F>(filters, null, null);
        ListIterator<F> iterator = filters.listIterator(filters.size());
        while (iterator.hasPrevious()) {
            chain = new DefaultServerAuthFilterChain<C, F>(filters, (ServerAuthFilter)iterator.previous(), chain);
        }
        return chain;
    }

    private DefaultServerAuthFilterChain(List<F> filters, @Nullable ServerAuthFilter<C> currentFilter, @Nullable DefaultServerAuthFilterChain<C, F> chain) {
        this.filters = filters;
        this.currentFilter = currentFilter;
        this.chain = chain;
    }

    @Override
    public Mono<Void> filter(C context) {
        return this.currentFilter != null && this.chain != null ? this.invokeFilter(this.currentFilter, this.chain, context) : Mono.empty();
    }

    public List<F> getFilters() {
        return this.filters;
    }

    protected Mono<Void> invokeFilter(ServerAuthFilter<C> filter, DefaultServerAuthFilterChain<C, F> chain, C context) {
        String currentName = filter.getClass().getName();
        return filter.filter(context, chain).checkpoint(currentName + CHECK_POINT_TAG);
    }
}

