/*
 * Decompiled with CFR 0.152.
 */
package com.power4j.fist.security.core.authorization.service;

import com.power4j.fist.security.core.authorization.domain.PermissionDefinition;
import com.power4j.fist.security.core.authorization.service.CacheHelper;
import com.power4j.fist.security.core.authorization.service.PermissionDefinitionService;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.cache.Cache;
import org.springframework.http.HttpMethod;

public abstract class AbstractPermissionDefinitionService<T extends PermissionDefinition>
implements PermissionDefinitionService<T> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AbstractPermissionDefinitionService.class);

    @Override
    public List<T> getPermissionDefinition(String serviceName, HttpMethod method) {
        return this.loadFromCache(serviceName, method).orElseGet(() -> {
            List list = this.fetch(serviceName, method).orElse(Collections.emptyList());
            if (!list.isEmpty()) {
                this.updateCache(serviceName, method, list);
            }
            return list;
        });
    }

    protected Optional<List<T>> loadFromCache(String serviceName, HttpMethod method) {
        return CacheHelper.loadFromCache(this.getCache().orElse(null), serviceName, method);
    }

    protected void updateCache(String serviceName, HttpMethod method, List<T> data) {
        CacheHelper.updateCache(this.getCache().orElse(null), serviceName, method, data);
    }

    protected abstract Optional<List<T>> fetch(String var1, HttpMethod var2);

    protected abstract Optional<Cache> getCache();
}

