/*
 * Decompiled with CFR 0.152.
 */
package com.power4j.fist.security.core.authorization.service;

import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.cache.Cache;
import org.springframework.http.HttpMethod;
import org.springframework.lang.Nullable;

public final class CacheHelper {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(CacheHelper.class);

    public static String makeCacheKey(String serviceName, HttpMethod method) {
        return serviceName + "::" + method.name();
    }

    public static <T> Optional<T> loadFromCache(@Nullable Cache cache, String serviceName, HttpMethod method) {
        if (Objects.isNull(cache)) {
            return Optional.empty();
        }
        String key = CacheHelper.makeCacheKey(serviceName, method);
        try {
            return Optional.ofNullable(cache.get((Object)key)).map(o -> o.get());
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return Optional.empty();
        }
    }

    public static <T> void updateCache(@Nullable Cache cache, String serviceName, HttpMethod method, List<T> data) {
        if (Objects.nonNull(cache)) {
            cache.put((Object)CacheHelper.makeCacheKey(serviceName, method), data);
        }
    }

    public static boolean removeCache(@Nullable Cache cache, String serviceName, HttpMethod method) {
        if (Objects.nonNull(cache)) {
            return cache.evictIfPresent((Object)CacheHelper.makeCacheKey(serviceName, method));
        }
        return false;
    }

    public static void removeCache(@Nullable Cache cache, String serviceName) {
        if (Objects.nonNull(cache)) {
            Arrays.stream(HttpMethod.values()).forEach(m -> cache.evict((Object)CacheHelper.makeCacheKey(serviceName, m)));
        }
    }

    @Generated
    private CacheHelper() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

