/*
 * Decompiled with CFR 0.152.
 */
package com.power4j.fist.security.core.authorization.service.reactive;

import com.power4j.fist.security.core.authorization.domain.PermissionDefinition;
import com.power4j.fist.security.core.authorization.service.CacheHelper;
import com.power4j.fist.security.core.authorization.service.reactive.ReactivePermissionDefinitionService;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.apache.commons.lang3.ObjectUtils;
import org.springframework.cache.Cache;
import org.springframework.http.HttpMethod;
import org.springframework.lang.Nullable;
import reactor.core.publisher.Mono;

public abstract class AbstractReactivePermissionDefinitionService<T extends PermissionDefinition>
implements ReactivePermissionDefinitionService<T> {
    @Override
    public Mono<List<T>> getPermissionDefinition(String serviceName, HttpMethod method) {
        return Mono.justOrEmpty(this.loadFromCache(serviceName, method)).switchIfEmpty(this.fetch(serviceName, method).doOnNext(o -> this.updateCache(serviceName, method, (List<T>)o)).switchIfEmpty(Mono.just(Collections.emptyList())));
    }

    @Nullable
    protected List<T> loadFromCache(String serviceName, HttpMethod method) {
        return CacheHelper.loadFromCache(this.getCache().orElse(null), serviceName, method).orElse(null);
    }

    protected void updateCache(String serviceName, HttpMethod method, List<T> data) {
        if (ObjectUtils.isNotEmpty(data)) {
            CacheHelper.updateCache(this.getCache().orElse(null), serviceName, method, data);
        }
    }

    protected void removeCache(String serviceName, HttpMethod method) {
        CacheHelper.removeCache(this.getCache().orElse(null), serviceName, method);
    }

    protected void removeCache(String serviceName) {
        CacheHelper.removeCache(this.getCache().orElse(null), serviceName);
    }

    protected abstract Mono<List<T>> fetch(String var1, HttpMethod var2);

    protected abstract Optional<Cache> getCache();
}

