/*
 * Decompiled with CFR 0.152.
 */
package com.power4j.fist.boot.common.api;

import com.power4j.coca.kit.common.lang.Result;
import com.power4j.fist.boot.common.error.RejectedException;
import java.util.HashMap;
import java.util.Objects;
import java.util.Optional;
import lombok.Generated;
import org.springframework.lang.Nullable;

public final class Results {
    public static final String META_KEY_HINT = "hint";

    public static <T> Result<T> resultWithHint(String code, @Nullable String message, @Nullable T data, @Nullable String hint) {
        Result result = Result.create((String)code, (String)message, data, null);
        if (Objects.nonNull(hint)) {
            HashMap<String, String> metadata = new HashMap<String, String>(1);
            metadata.put(META_KEY_HINT, hint);
            result.setMetaInfo(metadata);
        }
        return result;
    }

    public static <T> Result<T> ok(@Nullable String message, @Nullable T data) {
        return Results.resultWithHint("00000", message, data, null);
    }

    public static <T> Result<T> ok(@Nullable T data) {
        return Results.resultWithHint("00000", null, data, null);
    }

    public static <T> Result<T> ok() {
        return Results.resultWithHint("00000", null, null, null);
    }

    public static <T> Result<T> clientError(@Nullable String message, @Nullable String hint) {
        return Results.resultWithHint("A0001", message, null, hint);
    }

    public static <T> Result<T> requestParameterError(@Nullable String message, @Nullable String hint) {
        return Results.resultWithHint("A0400", message, null, hint);
    }

    public static <T> Result<T> serverError(@Nullable String message, @Nullable String hint) {
        return Results.resultWithHint("B0001", message, null, hint);
    }

    public static <T> Result<T> externalServiceError(@Nullable String message, @Nullable String hint) {
        return Results.resultWithHint("C0001", message, null, hint);
    }

    public static <T> Result<T> rpcError(@Nullable String message, @Nullable String hint) {
        return Results.resultWithHint("C0110", message, null, hint);
    }

    public static <T> Result<T> noPermission(@Nullable String message, @Nullable String hint) {
        return Results.resultWithHint("A0301", message, null, hint);
    }

    public static <T> Result<T> requiredData(@Nullable T data, @Nullable String hint) {
        String code = Objects.nonNull(data) ? "00000" : "A9900";
        String msg = Objects.nonNull(data) ? null : "Not found";
        return Results.resultWithHint(code, msg, data, hint);
    }

    public static <T> Result<T> requiredData(@Nullable T data) {
        return Results.requiredData(data, null);
    }

    public static <T> Result<T> requiredData(Optional<? extends T> opt) {
        return Results.requiredData(opt.orElse(null), null);
    }

    public static Result<?> fromError(RejectedException e) {
        return Results.resultWithHint(e.getCode(), e.getMessage(), null, e.getHint());
    }

    @Generated
    private Results() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

