/*
 * Decompiled with CFR 0.152.
 */
package com.power4j.fist.boot.common.error;

import com.power4j.fist.boot.common.error.RejectedException;
import com.power4j.fist.boot.i18n.LocaleResolver;
import java.util.Locale;
import java.util.Objects;
import java.util.Optional;
import lombok.Generated;
import org.springframework.context.support.MessageSourceAccessor;
import org.springframework.lang.Nullable;

public final class Breaker {
    @Nullable
    private static MessageSourceAccessor messageSourceAccessor;
    @Nullable
    private static LocaleResolver localeResolver;

    public static void requestParameterError(@Nullable String hint) throws RejectedException {
        Breaker.reject("A0400", "common.bad-parameter", null, hint);
    }

    public static void requestParameterError(String msgKey, @Nullable Object[] args, @Nullable String hint) throws RejectedException {
        Breaker.reject("A0400", msgKey, args, hint);
    }

    public static void resourceNotExistsError(@Nullable String hint) throws RejectedException {
        Breaker.requestParameterError("common.resource.not-found", null, hint);
    }

    public static <T> T fastFailOnNotExists(@Nullable T origin, @Nullable String hint) {
        if (Objects.isNull(origin)) {
            Breaker.resourceNotExistsError(hint);
        }
        assert (origin != null);
        return origin;
    }

    public static void permissionDeniedError(@Nullable String hint) throws RejectedException {
        Breaker.requestParameterError("common.permission.denied", null, hint);
    }

    public static void reject(String errorCode, String msgKey, @Nullable Object[] args) throws RejectedException {
        Breaker.reject(errorCode, msgKey, args, null);
    }

    public static void reject(String errorCode, String msgKey, @Nullable Object[] args, @Nullable String hint) throws RejectedException {
        Locale locale = Optional.ofNullable(localeResolver).map(LocaleResolver::resolve).orElse(Locale.CHINA);
        String msg = Objects.requireNonNull(messageSourceAccessor).getMessage(msgKey, args, msgKey, locale);
        Breaker.rise(errorCode, msg, hint);
    }

    public static void rise(String errorCode, String message, @Nullable String hint) {
        throw new RejectedException(errorCode, message, hint);
    }

    public static void setMessageSourceAccessor(MessageSourceAccessor messageSourceAccessor) {
        Breaker.messageSourceAccessor = Objects.requireNonNull(messageSourceAccessor);
    }

    public static void setLocaleResolver(LocaleResolver localeResolver) {
        Breaker.localeResolver = Objects.requireNonNull(localeResolver);
    }

    @Generated
    private Breaker() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

